/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.tree;

import fr.labri.gumtree.tree.TreeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Tree {
    public static final int NO_ID = Integer.MIN_VALUE;
    public static final String NO_LABEL = "";
    public static final int NO_METRIC = -1;
    private static final String OPEN_SYMBOL = "[(";
    private static final String CLOSE_SYMBOL = ")]";
    private static final String SEPARATE_SYMBOL = "@@";
    private int id;
    private int type;
    private String label;
    private Tree parent;
    private List<Tree> children;
    private int depth;
    private int digest;
    private boolean matched;
    private int height;
    private int size;
    private int pos;
    private int length;
    private String typeLabel;
    private Object tmpData;

    public Tree(int type) {
        this(type, NO_LABEL);
    }

    public Tree(int type, String label) {
        this(type, label, Integer.toString(type));
    }

    public Tree(int type, String label, String typeLabel) {
        this.type = type;
        this.label = label == null ? NO_LABEL : label;
        this.typeLabel = typeLabel;
        this.children = new ArrayList<Tree>();
        this.id = Integer.MIN_VALUE;
        this.depth = -1;
        this.digest = -1;
        this.height = -1;
        this.depth = -1;
        this.size = -1;
        this.matched = false;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isMatchable(Tree t) {
        return this.isCompatible(t) && !this.isMatched() && !t.isMatched();
    }

    public boolean isCompatible(Tree t) {
        return this.getType() == t.getType();
    }

    public boolean areDescendantsMatched() {
        for (Tree c : this.getDescendants()) {
            if (c.isMatched()) continue;
            return false;
        }
        return true;
    }

    public boolean isLeaf() {
        return this.getChildren().size() == 0;
    }

    public boolean isSimilar(Tree t) {
        if (!this.isCompatible(t)) {
            return false;
        }
        return this.getLabel().equals(t.getLabel());
    }

    public boolean isClone(Tree tree) {
        if (this.getDigest() != tree.getDigest()) {
            return false;
        }
        boolean res = this.toDigestTreeString().equals(tree.toDigestTreeString());
        return res;
    }

    public void refreshMetrics() {
        TreeUtils.computeAllMetrics(this);
    }

    public Tree deepCopy() {
        Tree copy = this.copy();
        for (Tree child : this.getChildren()) {
            copy.addChild(child.deepCopy());
        }
        return copy;
    }

    public Tree copy() {
        Tree t = new Tree(this.getType(), this.getLabel());
        t.setTypeLabel(this.getTypeLabel());
        t.setId(this.getId());
        t.setMatched(this.isMatched());
        t.setPos(this.getPos());
        t.setLength(this.getLength());
        t.setHeight(this.getHeight());
        t.setSize(this.getSize());
        t.setDepth(this.getDepth());
        t.setDigest(this.getDigest());
        t.setTmpData(this.getTmpData());
        return t;
    }

    public List<Tree> getTrees() {
        return TreeUtils.preOrder(this);
    }

    public List<Tree> getDescendants() {
        List<Tree> trees = TreeUtils.preOrder(this);
        trees.remove(0);
        return trees;
    }

    public List<Tree> getParents() {
        ArrayList<Tree> parents = new ArrayList<Tree>();
        if (this.getParent() == null) {
            return parents;
        }
        parents.add(this.getParent());
        parents.addAll(this.getParent().getParents());
        return parents;
    }

    public int getChildPosition(Tree child) {
        return this.children.indexOf(child);
    }

    public String getChildrenLabels() {
        StringBuffer b = new StringBuffer();
        for (Tree child : this.getChildren()) {
            if (NO_LABEL.equals(child.getLabel())) continue;
            b.append(child.getLabel() + " ");
        }
        return b.toString().trim();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree t = (Tree)o;
        if (t.id != Integer.MIN_VALUE) {
            return t.id == this.id;
        }
        return super.equals(t);
    }

    public List<Tree> getLeaves() {
        ArrayList<Tree> leafs = new ArrayList<Tree>();
        for (Tree t : this.getTrees()) {
            if (!t.isLeaf()) continue;
            leafs.add(t);
        }
        return leafs;
    }

    public int hashCode() {
        if (this.id != Integer.MIN_VALUE) {
            return this.id;
        }
        return super.hashCode();
    }

    public String toDigestString() {
        return this.getLabel() + SEPARATE_SYMBOL + this.getType();
    }

    public String toDigestTreeString() {
        StringBuffer b = new StringBuffer();
        b.append(OPEN_SYMBOL);
        b.append(this.toDigestString());
        for (Tree c : this.getChildren()) {
            b.append(c.toDigestTreeString());
        }
        b.append(CLOSE_SYMBOL);
        return b.toString();
    }

    public String toString() {
        if (!NO_LABEL.equals(this.getLabel())) {
            return this.getTypeLabel() + ": " + this.getLabel();
        }
        if (!NO_LABEL.equals(this.getChildrenLabels())) {
            return this.getTypeLabel() + ": " + this.getChildrenLabels();
        }
        return this.getTypeLabel();
    }

    public String toTreeString() {
        if (this.isLeaf()) {
            return this.toString();
        }
        StringBuffer b = new StringBuffer();
        b.append(this.toString() + " (");
        Iterator<Tree> cIt = this.getChildren().iterator();
        while (cIt.hasNext()) {
            Tree c = cIt.next();
            b.append(c.toTreeString());
            if (!cIt.hasNext()) continue;
            b.append(" ");
        }
        b.append(")");
        return b.toString();
    }

    public String toCompleteString() {
        return this.label + "@" + this.typeLabel + ":" + this.type + " [id=" + this.id + ", depth:" + this.depth + ", maxdepth=" + this.height + ", digest=" + this.digest + ", pos=" + this.pos + ", length=" + this.length + "]";
    }

    public String toCompleteTreeString() {
        if (this.isLeaf()) {
            return this.toString();
        }
        StringBuffer b = new StringBuffer();
        b.append(this.toString() + " (");
        for (Tree c : this.getChildren()) {
            b.append(c.toCompleteTreeString() + " ");
        }
        b.append(")");
        return b.toString();
    }

    public int getPos() {
        return this.pos;
    }

    public int getEndPos() {
        return this.pos + this.length;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public List<Tree> getChildren() {
        return this.children;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getDigest() {
        return this.digest;
    }

    public int getId() {
        return this.id;
    }

    public String getShortLabel() {
        return this.label.substring(0, Math.min(50, this.label.length()));
    }

    public String getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public Tree getParent() {
        return this.parent;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public boolean isMatched() {
        return this.matched;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setDigest(int digest) {
        this.digest = digest;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    public void addChild(Tree t) {
        this.children.add(t);
        t.setParent(this);
    }

    public void setChildren(List<Tree> children) {
        this.children = children;
        for (Tree c : children) {
            c.setParent(this);
        }
    }

    public void setParentAndUpdateChildren(Tree parent) {
        if (this.parent != null) {
            this.parent.getChildren().remove(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            parent.getChildren().add(this);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setTypeLabel(String typeLabel) {
        this.typeLabel = typeLabel;
    }

    public Object getTmpData() {
        return this.tmpData;
    }

    public void setTmpData(Object tmpData) {
        this.tmpData = tmpData;
    }
}

