/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.issues;

import fr.labri.harmony.Action;
import fr.labri.harmony.ActionKind;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.Source;
import fr.labri.harmony.SourceFactories;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.issues.BugtrackerProducer;
import fr.labri.harmony.source.issues.BugtrackerWorkspace;
import fr.labri.harmony.source.issues.IBugtrackerAdapter;
import fr.labri.harmony.source.issues.IssueData;
import fr.labri.harmony.utils.FileUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractBugTrackerAdapter
implements IBugtrackerAdapter {
    private BugtrackerWorkspace workspace;
    private SourceFactories factories;
    private Map<String, IssueData> issues = new HashMap<String, IssueData>();

    @Override
    public void init(BugtrackerProducer producer, Source src) throws WorkspaceException {
        this.setWorkspace(new BugtrackerWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder())));
        this.getWorkspace().init();
        this.setFactories(producer.getFactories());
    }

    @Override
    public final void createActions(Source src, Item item) throws CreateSourceException {
        for (Event event : src.getEvents()) {
            Metadata data = (Metadata)event.getData().iterator().next();
            if (!item.getNativeId().equals(data.getMetadata().get("issueId"))) continue;
            Action action = new Action();
            action.setItem(item);
            action.setId(event.getId());
            action.setEvent(event);
            action.setKind(ActionKind.Edit);
            item.getActions().add(action);
        }
    }

    public final BugtrackerWorkspace getWorkspace() {
        return this.workspace;
    }

    public final void setWorkspace(BugtrackerWorkspace workspace) {
        this.workspace = workspace;
    }

    public final SourceFactories getFactories() {
        return this.factories;
    }

    public final void setFactories(SourceFactories factories) {
        this.factories = factories;
    }

    public final Map<String, IssueData> getIssues() {
        return this.issues;
    }

    public final void setIssues(Map<String, IssueData> issues) {
        this.issues = issues;
    }
}

