/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.issues;

import fr.labri.harmony.Author;
import fr.labri.harmony.Data;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.issues.AbstractBugTrackerAdapter;
import fr.labri.harmony.source.issues.BugtrackerProducer;
import fr.labri.harmony.source.issues.BugzillaExtractor;
import fr.labri.harmony.source.issues.Comment;
import fr.labri.harmony.source.issues.IssueData;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;

public class BugzillaAdapter
extends AbstractBugTrackerAdapter {
    private BugzillaExtractor extractor;

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new BugtrackerProducer(new BugzillaAdapter(), config, task, factory);
    }

    @Override
    public final void init(BugtrackerProducer producer, Source src) throws WorkspaceException {
        super.init(producer, src);
        this.extractor = new BugzillaExtractor(src.getUrl());
        CreateSource.LOGGER.info("Getting issues from " + src.getUrl());
        try {
            this.extractor.downloadIssues();
            CreateSource.LOGGER.info("Got " + this.extractor.getIssues().size() + " Issues");
            this.extractor.extractAllBugsHistories();
            CreateSource.LOGGER.info("Got " + this.extractor.getIssueEvents().size() + " issue event");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final Set<Item> createItems(Source src) throws CreateSourceException {
        HashSet<Item> items = new HashSet<Item>();
        for (IssueData i : this.extractor.getIssues()) {
            Item item = this.getFactories().items.create(String.valueOf(i.getNativeId()), src);
            i.setHarmonyElement(item);
            if (i.getAssignee() != null) {
                i.getAssignee().setSource(src);
            }
            if (i.getReporter() != null) {
                i.getReporter().setSource(src);
            }
            if (!i.getComments().isEmpty()) {
                for (Comment c : i.getComments()) {
                    c.getAuthor().setSource(src);
                }
            }
            item.getData().add(i);
            src.getItems().add(item);
            items.add(item);
        }
        this.getIssueEvents(src);
        return items;
    }

    private void getIssueEvents(Source src) {
        for (Event ievent : this.extractor.getIssueEvents()) {
            if (ievent.getData() == null) continue;
            Event event = this.getFactories().events.create(ievent.getNativeId(), src, ievent.getTimestamp());
            Set<Data> edata = ievent.getData();
            for (Data data : edata) {
                data.setHarmonyElement(event);
                event.getData().add(data);
            }
            for (Author a : ievent.getAuthors()) {
                a.setSource(src);
                event.getAuthors().add(a);
            }
            event.setSource(src);
            src.getEvents().add(event);
        }
        CreateSource.LOGGER.info("-> Got " + src.getEvents().size() + " issue event and " + src.getItems().size() + " issue");
        CreateSource.LOGGER.info("Job done for the source " + src.getUrl());
    }
}

