/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.issues;

import fr.labri.harmony.Author;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.issues.AbstractBugTrackerAdapter;
import fr.labri.harmony.source.issues.BugtrackerProducer;
import fr.labri.harmony.source.issues.IssueData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.IssueEvent;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.service.IssueService;
import org.hibernate.SessionFactory;

public class GithubAdapter
extends AbstractBugTrackerAdapter {
    private IssueService issueService = new IssueService(new GitHubClient());
    private List<Author> authors;
    private RepositoryId id;
    private static final int URL_SIZE = 5;
    private static final int NAME_INDEX = 4;
    private static final int OWNER_INDEX = 3;

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new BugtrackerProducer(new GithubAdapter(), config, task, factory);
    }

    @Override
    public final void init(BugtrackerProducer producer, Source src) throws WorkspaceException {
        GitHubClient client = this.issueService.getClient();
        client.setCredentials("amineraji", "ENSIijar23");
        this.authors = new ArrayList<Author>();
        super.init(producer, src);
        String[] result = src.getUrl().split("/");
        if (result.length < 5) {
            try {
                throw new IOException();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String owner = result[3];
        String name = result[4];
        this.id = new RepositoryId(owner, name);
    }

    @Override
    public final Set<Item> createItems(Source src) throws CreateSourceException {
        HashMap<String, String> filter = new HashMap<String, String>();
        CreateSource.LOGGER.info("Downloading issues from " + src.getUrl());
        filter.put("state", "closed");
        this.extractFiltredIssues(src, filter);
        filter.put("state", "open");
        this.extractFiltredIssues(src, filter);
        Set<Item> items = this.getItems(src);
        CreateSource.LOGGER.info("Downloading issue events from " + src.getUrl());
        this.getIssueEvents(src);
        return items;
    }

    private Set<Item> getItems(Source src) {
        HashSet<Item> result = new HashSet<Item>();
        for (String i : this.getIssues().keySet()) {
            Item item = this.getFactories().items.create(i, src);
            IssueData idata = this.getIssues().get(i);
            idata.setHarmonyElement(item);
            item.getData().add(idata);
            src.getItems().add(item);
            result.add(item);
        }
        return result;
    }

    private void getIssueEvents(Source src) {
        PageIterator iter = this.issueService.pageEvents(this.id.getOwner(), this.id.getName());
        for (Collection page : iter) {
            for (IssueEvent ievent : page) {
                if (ievent.getIssue() == null) continue;
                Event event = this.getFactories().events.create(String.valueOf(ievent.getId()), src, ievent.getCreatedAt().getTime());
                Metadata edata = new Metadata();
                edata.getMetadata().put("issueId", String.valueOf(ievent.getIssue().getNumber()));
                edata.setHarmonyElement(event);
                event.getData().add(edata);
                if (ievent.getActor() != null) {
                    Author author = this.getAuthorByName(ievent.getActor().getLogin());
                    author.setName(ievent.getActor().getName());
                    author.setSource(src);
                    event.getAuthors().add(author);
                }
                event.setNativeId(String.valueOf(ievent.getId()));
                event.setTimestamp(ievent.getCreatedAt().getTime());
                event.setSource(src);
                src.getEvents().add(event);
            }
        }
        CreateSource.LOGGER.info("-> Got " + src.getEvents().size() + " issue event from " + src.getUrl());
    }

    private void extractFiltredIssues(Source src, Map<String, String> filter) {
        List result = null;
        try {
            result = this.issueService.getIssues((IRepositoryIdProvider)this.id, filter);
            for (Issue i : result) {
                this.getIssues().put(String.valueOf(i.getNumber()), this.createIssue(i));
            }
            CreateSource.LOGGER.info("-> Got " + result.size() + " " + filter.get("state") + " issues from " + src.getUrl());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private IssueData createIssue(Issue i) {
        IssueData result = new IssueData(i.getNumber());
        Author assignee = new Author();
        if (i.getAssignee() != null) {
            assignee.setName(i.getAssignee().getName());
        }
        result.setAssignee(assignee);
        Author reporter = new Author();
        if (i.getUser() != null) {
            reporter.setName(i.getUser().getName());
        }
        result.setReporter(reporter);
        result.setTitle(i.getTitle());
        result.setResolution(i.getState());
        result.setCreatedAt(i.getCreatedAt().getTime());
        if (i.getClosedAt() != null) {
            result.setClosedAt(i.getClosedAt().getTime());
        }
        if (i.getLabels() != null) {
            HashSet<String> labels = new HashSet<String>();
            for (Label l : i.getLabels()) {
                labels.add(l.getName());
            }
            result.setLabels(labels);
        }
        return result;
    }

    private Author getAuthorByName(String alias) {
        for (Author aut : this.authors) {
            if (!aut.getNativeId().equals(alias)) continue;
            return aut;
        }
        Author a = new Author();
        a.setNativeId(alias);
        this.authors.add(a);
        return a;
    }
}

