/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs;

import fr.labri.harmony.Event;
import fr.labri.harmony.Source;
import fr.labri.harmony.Workspace;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.utils.FileUtils;

public abstract class VCSWorkspace
implements Workspace {
    protected String url;
    protected String path;

    public VCSWorkspace(Source src, String url, String path) {
        this.url = url;
        this.path = path;
        src.setWorkspace(this);
        src.setUrl(url);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void init() throws WorkspaceException {
        CreateSource.LOGGER.info("Initializing source " + this.url + " into " + this.path + ".");
        this.doInit();
    }

    public abstract void doInit() throws WorkspaceException;

    @Override
    public String update(Event e) throws WorkspaceException {
        CreateSource.LOGGER.info("Updating source " + this.url + " to event " + e.getNativeId() + ".");
        return this.doUpdate(e);
    }

    public abstract String doUpdate(Event var1) throws WorkspaceException;

    @Override
    public void clean() throws WorkspaceException {
        CreateSource.LOGGER.info("Deleting source " + this.url + " from " + this.path + ".");
        FileUtils.deleteFolder(this.path);
    }
}

