/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.bzr;

import fr.labri.harmony.source.vcs.bzr.BzrChangeset;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BzrRepoFacade {
    private File repo;

    public BzrRepoFacade(String path) {
        this.repo = new File(path);
    }

    public List<BzrChangeset> getLog() throws IOException {
        ArrayList<BzrChangeset> ret = new ArrayList<BzrChangeset>();
        HashMap<String, BzrChangeset> map = new HashMap<String, BzrChangeset>();
        String[] cmd = new String[]{"bzr", "log", "--show-id", "--include-merges", "--xml", this.repo.getAbsolutePath()};
        Process proc = Runtime.getRuntime().exec(cmd);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(new BufferedInputStream(proc.getInputStream()));
            Element root = document.getDocumentElement();
            NodeList list = root.getElementsByTagName("log");
            SimpleDateFormat sdf = new SimpleDateFormat("EEE yyyy-MM-dd HH:mm:ss Z");
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                Node leaf = n.getFirstChild();
                String revId = "";
                int revNo = -1;
                String committer = "";
                String branch = "";
                Date date = null;
                ArrayList<BzrChangeset> parents = new ArrayList<BzrChangeset>();
                while (leaf != null) {
                    if (leaf.getNodeType() == 1) {
                        if (leaf.getNodeName().equals("revno")) {
                            revNo = new Integer(leaf.getNodeValue());
                        }
                        if (leaf.getNodeName().equals("committer")) {
                            committer = leaf.getNodeValue();
                        }
                        if (leaf.getNodeName().equals("timestamp")) {
                            date = sdf.parse(leaf.getNodeValue());
                        }
                        if (leaf.getNodeName().equals("branch-nick")) {
                            branch = leaf.getNodeValue();
                        }
                        if (leaf.getNodeName().equals("revisionid")) {
                            revId = leaf.getNodeValue();
                        }
                        if (leaf.getNodeName().equals("parents")) {
                            Node parent = leaf.getFirstChild();
                            while (parent != null) {
                                if (parent.getNodeName().equals("parent")) {
                                    String parentName = parent.getNodeValue();
                                    parents.add((BzrChangeset)map.get(parentName));
                                }
                                parent = parent.getNextSibling();
                            }
                        }
                    }
                    leaf = leaf.getNextSibling();
                }
                BzrChangeset changeset = new BzrChangeset(committer, date, revNo, revId, branch, parents);
                ret.add(changeset);
                map.put(changeset.getRevId(), changeset);
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public List<String> getAddedFiles(int revNo) {
        return this.getTouchedFiles(revNo, "added");
    }

    public List<String> getRemovedFiles(int revNo) {
        return this.getTouchedFiles(revNo, "removed");
    }

    public List<String> getModifiedFiles(int revNo) {
        return this.getTouchedFiles(revNo, "modified");
    }

    private List<String> getTouchedFiles(int revNo, String type) {
        String[] cmd = new String[]{"bzr", "log", "-v", "-r " + revNo, "--xml"};
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(new BufferedInputStream(proc.getInputStream()));
            Element root = document.getDocumentElement();
            Node added = root.getElementsByTagName(type).item(0);
            NodeList addedList = ((Element)added).getElementsByTagName("file");
            int i = 0;
            while (i < addedList.getLength()) {
                Node n = addedList.item(i);
                String file = n.getNodeValue();
                ret.add(file);
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

