/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.git;

import fr.labri.harmony.Action;
import fr.labri.harmony.ActionKind;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.NativeElementNotFound;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.VCSAdapter;
import fr.labri.harmony.source.vcs.VCSWorkspace;
import fr.labri.harmony.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;

public class NativeGitAdapter
extends VCSAdapter {
    protected NativeGitWorkspace workspace;

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new CreateVCSSource(new NativeGitAdapter(), config, task, factory);
    }

    @Override
    public void init(CreateVCSSource producer, Source src) throws WorkspaceException {
        this.factories = producer.getFactories();
        this.workspace = new NativeGitWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder()));
        this.workspace.init();
    }

    @Override
    public Event[] createEvents(Source src) throws CreateSourceException {
        try {
            ArrayList<Event> events = new ArrayList<Event>();
            ProcessBuilder b = new ProcessBuilder("git", "log", "--topo-order", "--reverse", "--format=%H,%P,%ad");
            b.directory(this.workspace.fpath);
            Process p = b.start();
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = r.readLine()) != null) {
                String[] commit = line.split("\\,");
                String hash = commit[0];
                String[] parents = new String[]{};
                if (commit.length > 1) {
                    parents = commit[1].split("\\s");
                }
                SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM WW HH:mm:ss yyyy Z", Locale.ENGLISH);
                Date date = formatter.parse(commit[2]);
                long ctime = date.getTime();
                Event e = this.factories.events.create(hash, src, ctime);
                events.add(e);
                HashSet<Event> eparents = new HashSet<Event>();
                String[] stringArray = parents;
                int n = parents.length;
                int n2 = 0;
                while (n2 < n) {
                    String parent = stringArray[n2];
                    if (this.factories.events.has(parent)) {
                        eparents.add((Event)this.factories.events.get(parent));
                    }
                    ++n2;
                }
                e.setParents(eparents);
            }
            p.waitFor();
            r.close();
            return events.toArray(new Event[events.size()]);
        }
        catch (Exception e) {
            throw new CreateSourceException(e);
        }
    }

    @Override
    public void createActions(Source src, Event e) throws CreateSourceException {
        try {
            if (e.getParents().size() == 0) {
                String line;
                ProcessBuilder b = new ProcessBuilder("git", "diff", "--name-status", "--no-renames", e.getNativeId());
                b.directory(this.workspace.fpath);
                Process p = b.start();
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = r.readLine()) != null) {
                    this.extractAction(line, e, src);
                }
                p.waitFor();
                r.close();
            } else {
                for (Event parent : e.getParents()) {
                    String line;
                    ProcessBuilder b = new ProcessBuilder("git", "diff", "--name-status", "--no-renames", e.getNativeId(), parent.getNativeId());
                    b.directory(this.workspace.fpath);
                    Process p = b.start();
                    BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = r.readLine()) != null) {
                        Action a = this.extractAction(line, e, src);
                        a.setParentEvent(parent);
                    }
                    p.waitFor();
                    r.close();
                }
            }
        }
        catch (Exception ex) {
            throw new CreateSourceException(ex);
        }
    }

    private Action extractAction(String line, Event e, Source src) {
        String[] tokens = line.split("\\s+");
        Action a = new Action();
        Item i = null;
        try {
            i = (Item)this.factories.items.tryGet(tokens[1]);
        }
        catch (NativeElementNotFound ne) {
            i = this.factories.items.create(tokens[1], src);
        }
        a.setItem(i);
        i.getActions().add(a);
        a.setEvent(e);
        e.getActions().add(a);
        switch (tokens[0]) {
            case "A": {
                a.setKind(ActionKind.Create);
                break;
            }
            case "M": {
                a.setKind(ActionKind.Edit);
                break;
            }
            case "D": {
                a.setKind(ActionKind.Delete);
                break;
            }
            default: {
                System.out.println(tokens[0]);
            }
        }
        return a;
    }

    protected static class NativeGitWorkspace
    extends VCSWorkspace {
        protected File fpath;

        protected NativeGitWorkspace(Source src, String url, String path) {
            super(src, url, path);
            this.fpath = new File(path);
        }

        @Override
        public void doInit() throws WorkspaceException {
            try {
                ProcessBuilder b = new ProcessBuilder("git", "clone", this.url, this.fpath.getAbsolutePath());
                Process p = b.start();
                p.waitFor();
            }
            catch (Exception e) {
                throw new WorkspaceException(e);
            }
        }

        @Override
        public String doUpdate(Event e) throws WorkspaceException {
            try {
                ProcessBuilder b = new ProcessBuilder("git", "reset", "--hard", e.getNativeId());
                b.directory(this.fpath);
                Process p = b.start();
                p.waitFor();
                return this.path;
            }
            catch (Exception ex) {
                throw new WorkspaceException(ex);
            }
        }
    }
}

