/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.hg;

import fr.labri.harmony.Action;
import fr.labri.harmony.ActionKind;
import fr.labri.harmony.Author;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.NativeElementNotFound;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.VCSAdapter;
import fr.labri.harmony.source.vcs.VCSWorkspace;
import fr.labri.harmony.utils.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;
import org.tmatesoft.hg.core.HgCallbackTargetException;
import org.tmatesoft.hg.core.HgChangeset;
import org.tmatesoft.hg.core.HgException;
import org.tmatesoft.hg.core.HgRepoFacade;
import org.tmatesoft.hg.core.HgStatus;
import org.tmatesoft.hg.core.HgStatusCommand;
import org.tmatesoft.hg.core.HgStatusHandler;
import org.tmatesoft.hg.util.Outcome;
import org.tmatesoft.hg.util.Path;

public class Hg4JAdapter
extends VCSAdapter {
    private static final long MILLI_2_SECONDS = 1000L;
    private HgWorkspace workspace;
    private Map<String, HgChangeset> changeSets = new HashMap<String, HgChangeset>();
    private Map<String, HgStatus.Kind> editedItems = new HashMap<String, HgStatus.Kind>();

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new CreateVCSSource(new Hg4JAdapter(), config, task, factory);
    }

    @Override
    public void init(CreateVCSSource producer, Source src) throws WorkspaceException {
        this.factories = producer.getFactories();
        this.workspace = new HgWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder()));
        this.workspace.init();
    }

    @Override
    public Event[] createEvents(Source src) throws CreateSourceException {
        try {
            List result = this.workspace.getHgRepoFacade().createLogCommand().execute();
            ArrayList<Event> events = new ArrayList<Event>();
            for (HgChangeset cset : result) {
                String revId = cset.getNodeid().toString();
                this.changeSets.put(revId, cset);
                Metadata metadata = new Metadata();
                metadata.getMetadata().put("commit_log", cset.getComment());
                metadata.getMetadata().put("branch", cset.getBranch());
                long time = cset.getDate().getRawTime() / 1000L;
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
                if (formatter.format(new Date(time)).equals("1970")) {
                    time *= 1000L;
                }
                Event e = this.factories.events.create(revId, src, time);
                metadata.setHarmonyElement(e);
                events.add(e);
                e.getData().add(metadata);
                HashSet<Event> parents = new HashSet<Event>();
                if (!cset.getFirstParentRevision().isNull()) {
                    parents.add((Event)this.factories.events.get(cset.getFirstParentRevision().toString()));
                }
                if (!cset.getSecondParentRevision().isNull()) {
                    parents.add((Event)this.factories.events.get(cset.getSecondParentRevision().toString()));
                }
                e.setParents(parents);
                HashSet<Author> authors = new HashSet<Author>();
                String user = cset.getUser();
                Author author = null;
                try {
                    author = (Author)this.factories.authors.tryGet(user);
                }
                catch (NativeElementNotFound ne) {
                    author = this.factories.authors.create(user, src, user);
                }
                authors.add(author);
                e.setAuthors(authors);
                author.getEvents().add(e);
            }
            return events.toArray(new Event[events.size()]);
        }
        catch (HgException e) {
            throw new CreateSourceException((Exception)((Object)e));
        }
    }

    @Override
    public void createActions(Source src, Event e) throws CreateSourceException {
        HgChangeset current = this.changeSets.get(e.getNativeId());
        HgStatusCommand cmd = this.workspace.getHgRepoFacade().createStatusCommand();
        for (Event p : e.getParents()) {
            HgChangeset parent = this.changeSets.get(p.getNativeId());
            cmd = cmd.base(parent.getRevisionIndex()).revision(current.getRevisionIndex());
            this.editedItems = new HashMap<String, HgStatus.Kind>();
            try {
                cmd.all().execute((HgStatusHandler)new MyHgStatusHandler());
            }
            catch (Exception exc) {
                throw new CreateSourceException(exc);
            }
            for (String path : this.editedItems.keySet()) {
                HgStatus.Kind status = this.editedItems.get(path);
                ActionKind kind = null;
                switch (status) {
                    case Added: {
                        kind = ActionKind.Create;
                        break;
                    }
                    case Modified: {
                        kind = ActionKind.Edit;
                        break;
                    }
                    case Removed: {
                        kind = ActionKind.Delete;
                    }
                }
                if (kind == null) continue;
                Item i = null;
                try {
                    i = (Item)this.factories.items.tryGet(path);
                }
                catch (NativeElementNotFound ne) {
                    i = this.factories.items.create(path, src);
                }
                Action a = new Action(i, kind, e, p);
                e.getActions().add(a);
                i.getActions().add(a);
            }
        }
    }

    private static final class HgWorkspace
    extends VCSWorkspace {
        private HgRepoFacade hg;

        private HgWorkspace(Source src, String url, String path) {
            super(src, url, path);
        }

        private HgRepoFacade getHgRepoFacade() {
            return this.hg;
        }

        @Override
        public void doInit() throws WorkspaceException {
            try {
                this.hg = new HgRepoFacade();
                String[] cmdArray = new String[]{"hg", "clone", this.url, this.path};
                Process p = Runtime.getRuntime().exec(cmdArray);
                p.waitFor();
                this.hg.initFrom(new File(this.path));
            }
            catch (Exception e) {
                throw new WorkspaceException(e);
            }
        }

        @Override
        public String doUpdate(Event e) {
            try {
                String[] cmdArray = new String[]{"hg", "update", "-r", e.getNativeId()};
                Process p = Runtime.getRuntime().exec(cmdArray, new String[0], new File(this.path));
                p.waitFor();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return this.path;
        }
    }

    private class MyHgStatusHandler
    implements HgStatusHandler {
        private MyHgStatusHandler() {
        }

        public void status(HgStatus status) throws HgCallbackTargetException {
            Hg4JAdapter.this.editedItems.put(status.getPath().toString(), status.getKind());
        }

        public void error(Path arg0, Outcome arg1) throws HgCallbackTargetException {
        }
    }
}

