/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.utils;

import fr.labri.harmony.Source;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FileUtils {
    private FileUtils() {
    }

    public static String convertToFolderName(Source src) {
        String[] parts = src.getUrl().split("\\/");
        return parts[parts.length - 1].replaceAll("\\:", "");
    }

    public static String getExtension(String path) {
        return path.substring(path.lastIndexOf(".") + 1).toLowerCase();
    }

    public static void deleteFolder(String path) {
        FileUtils.deleteFolder(new File(path));
    }

    public static void deleteFolder(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.deleteFolder(new File(dir, children[i]));
                ++i;
            }
        }
        dir.delete();
    }

    public static String createTmpFolder(String path) {
        try {
            File fTmpPath;
            File folder = null;
            folder = "".equals(path) ? ((fTmpPath = new File(path)).exists() && fTmpPath.canWrite() ? File.createTempFile("checkout_", "", fTmpPath) : File.createTempFile("checkout_", "")) : File.createTempFile("checkout_", "");
            folder.delete();
            folder.mkdir();
            return folder.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static void listAllFiles(File path, List<String> allFiles, String extension) {
        if (path.isDirectory()) {
            File[] list = path.listFiles();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    FileUtils.listAllFiles(list[i], allFiles, extension);
                    ++i;
                }
            }
        } else {
            String currentFilePath = path.getAbsolutePath();
            if (currentFilePath.toLowerCase().endsWith(extension)) {
                allFiles.add(currentFilePath);
            }
        }
    }

    public static List<String> listAllFiles(String filePath, final String extension) {
        ArrayList<String> allFiles = new ArrayList<String>();
        File path = new File(filePath);
        if (path.isDirectory()) {
            File[] list;
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(extension.toLowerCase());
                }
            };
            File[] fileArray = list = path.listFiles(filter);
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                allFiles.addAll(FileUtils.listAllFiles(file.getAbsolutePath(), extension));
                ++n2;
            }
        } else {
            allFiles.add(filePath);
        }
        return allFiles;
    }
}

