/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source;

import fr.labri.harmony.Source;
import fr.labri.harmony.SourceFactories;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonNode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public abstract class CreateSource {
    public static final Logger LOGGER = Logger.getLogger("fr.labri.harmony.source.CreateSource");
    protected JsonNode config;
    protected SessionFactory factory;
    protected SourceFactories factories = new SourceFactories();
    protected SourceAnalysis analysis;

    public CreateSource(JsonNode config, SourceAnalysis analysis, SessionFactory factory) {
        this.config = config;
        this.analysis = analysis;
        this.factory = factory;
    }

    protected final void run() {
        try {
            Session sess = this.factory.openSession();
            sess.beginTransaction();
            Source src = this.createSource();
            src.setSessionFactory(this.factory);
            if (this.analysis != null) {
                this.analysis.perform(src);
            }
            sess.saveOrUpdate((Object)src);
            sess.flush();
            sess.getTransaction().commit();
            sess.close();
            src.getWorkspace().clean();
        }
        catch (Exception ex) {
            LOGGER.severe(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public abstract Source createSource() throws CreateSourceException, WorkspaceException;

    public SourceFactories getFactories() {
        return this.factories;
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public JsonNode getConfig() {
        return this.config;
    }

    public String getURL() {
        return this.config.get("url").asText();
    }

    public String getTmpFolder() {
        return "";
    }
}

