/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source;

import fr.labri.harmony.source.CreateSource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.JsonNode;

public final class ManageCreateSources {
    private ExecutorService serv;
    private JsonNode config;
    private static ManageCreateSources instance = null;

    private ManageCreateSources(JsonNode config) {
        this.config = config;
        this.serv = Executors.newFixedThreadPool(config.get("threads").asInt());
    }

    public static void initialize(JsonNode config) {
        instance = new ManageCreateSources(config);
    }

    public void addCreateSource(final CreateSource createSource) {
        this.serv.execute(new Runnable(){

            @Override
            public void run() {
                createSource.run();
            }
        });
    }

    public void addCreateSources(Iterable<CreateSource> createSources) {
        for (CreateSource producer : createSources) {
            this.addCreateSource(producer);
        }
    }

    public void shutdown(boolean force) {
        if (force) {
            this.serv.shutdownNow();
        } else {
            this.serv.shutdown();
            try {
                this.serv.awaitTermination(Integer.valueOf(this.config.get("timeout").asInt()).intValue(), TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                this.serv.shutdownNow();
            }
        }
    }

    public static ManageCreateSources getInstance() {
        return instance;
    }
}

