/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.issues;

import fr.labri.harmony.Author;
import fr.labri.harmony.Event;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.issues.Comment;
import fr.labri.harmony.source.issues.IssueData;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class BugzillaExtractor {
    private static final String LIMIT_0 = "&limit=0";
    public static final int TIMEOUT = 30000;
    private static final String BUGZILLA_SHOW_DETAILS_TOKKEN = "show_bug.cgi?ctype=xml";
    private static final String BUGZILLA_SHOW_ACTIVITY_TOKKEN = "show_activity.cgi?id=";
    private static final long SLEEP_DELAY = 3000L;
    private static final int MAX_ISSUES_DOWNLOAD = 20;
    private String url;
    private List<IssueData> issues;
    private List<Author> authors;
    private List<Comment> comments;
    private XMLInputFactory inFactory;
    private List<Event> issueEvents;
    private String baseUrl;

    public BugzillaExtractor(String url) {
        this.url = url;
        this.baseUrl = url.substring(0, url.indexOf("buglist.cgi"));
        this.issues = new ArrayList<IssueData>();
        this.issueEvents = new ArrayList<Event>();
        this.authors = new ArrayList<Author>();
        this.comments = new ArrayList<Comment>();
        this.inFactory = XMLInputFactory.newInstance();
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", false);
        this.inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", true);
        this.inFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
    }

    public final void downloadIssues() throws IOException, InterruptedException {
        List<Integer> bugList = this.extractBuglist();
        String query = "";
        if (bugList.size() < 20) {
            query = this.buildQuery(bugList);
            CreateSource.LOGGER.info("Downloading issues N\u00b0: " + bugList);
            this.extractBugDetailsFromXMLUrl(query);
        } else {
            int i = 0;
            while (i < bugList.size()) {
                ArrayList<Integer> tmpList = new ArrayList<Integer>();
                int j = i;
                while (j < i + 20 && j < bugList.size()) {
                    tmpList.add(bugList.get(j));
                    ++j;
                }
                query = this.buildQuery(tmpList);
                CreateSource.LOGGER.info("Downloading issues N\u00b0: " + tmpList);
                this.extractBugDetailsFromXMLUrl(query);
                CreateSource.LOGGER.info("Sleeping for 3000 ms");
                i += 20;
            }
        }
        Thread.sleep(3000L);
    }

    private List<Integer> extractBuglist() throws IOException {
        ArrayList<Integer> bugs = new ArrayList<Integer>();
        Document doc = Jsoup.connect((String)(String.valueOf(this.url) + LIMIT_0)).timeout(30000).get();
        Elements content = doc.getElementsByClass("bz_bugitem");
        for (Element elem : content) {
            int bugId = 0;
            Elements bugInfo = elem.getElementsByTag("a");
            Iterator iterator = bugInfo.iterator();
            if (iterator.hasNext()) {
                Element e = (Element)iterator.next();
                bugId = Integer.parseInt(e.text());
            }
            bugs.add(bugId);
        }
        return bugs;
    }

    private String buildQuery(List<Integer> bugList) {
        String result = String.valueOf(this.baseUrl) + BUGZILLA_SHOW_DETAILS_TOKKEN;
        for (Integer i : bugList) {
            result = String.valueOf(result) + "&id=" + i;
        }
        return result;
    }

    public final IssueData getIssueByNumber(int num) {
        for (IssueData i : this.issues) {
            if (i.getNativeId() != num) continue;
            return i;
        }
        return null;
    }

    private void extractBugDetailsFromXMLUrl(String urlString) {
        try {
            URLConnection conn = new URL(urlString).openConnection();
            XMLEventReader eventReader = this.inFactory.createXMLEventReader(conn.getInputStream());
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !((StartElement)event).getName().toString().equals("bug")) continue;
                this.issues.add(this.parseBugEvent(eventReader));
            }
        }
        catch (XMLStreamException e1) {
            e1.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getEventData(XMLEventReader eventReader) {
        try {
            XMLEvent e = eventReader.nextEvent();
            if (e.isCharacters()) {
                return ((Characters)e).getData().replaceAll("\n", "").trim();
            }
            return null;
        }
        catch (XMLStreamException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private IssueData parseBugEvent(XMLEventReader eventReader) {
        IssueData result = null;
        try {
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    String s = ((StartElement)event).getName().toString();
                    if (s.equals("bug_id")) {
                        result = new IssueData(Integer.parseInt(this.getEventData(eventReader)));
                    }
                    if (s.equals("creation_ts")) {
                        result.setCreatedAt(this.getTimestamp(this.getEventData(eventReader)));
                    }
                    if (s.equals("short_desc")) {
                        result.setTitle(this.getEventData(eventReader));
                    }
                    if (s.equals("product")) {
                        result.setProduct(this.getEventData(eventReader));
                    }
                    if (s.equals("component")) {
                        result.setComponent(this.getEventData(eventReader));
                    }
                    if (s.equals("version")) {
                        result.setVersion(this.getEventData(eventReader));
                    }
                    if (s.equals("resolution")) {
                        result.setResolution(this.getEventData(eventReader));
                    }
                    if (s.equals("bug_severity")) {
                        result.setSeverity(this.getEventData(eventReader));
                    }
                    if (s.equals("reporter")) {
                        result.setReporter(this.getAuthor(eventReader, event));
                    }
                    if (s.equals("assigned_to")) {
                        result.setAssignee(this.getAuthor(eventReader, event));
                    }
                    if (!s.equals("long_desc")) continue;
                    Comment cmt = this.parseComment(eventReader);
                    cmt.setIssue(result);
                    result.getComments().add(cmt);
                    continue;
                }
                if (!event.isEndElement() || !((EndElement)event).getName().toString().equals("bug")) continue;
                return result;
            }
        }
        catch (XMLStreamException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    private Author getAuthor(XMLEventReader eventReader, XMLEvent event) {
        Attribute att = ((StartElement)event).getAttributeByName(new QName("name"));
        String devName = "";
        if (att != null) {
            devName = att.getValue();
            for (Author dev : this.authors) {
                if (!dev.getName().equals(devName)) continue;
                return dev;
            }
            Author d = new Author();
            d.setNativeId(devName);
            d.setName(this.getEventData(eventReader));
            this.authors.add(d);
            return d;
        }
        return null;
    }

    private Comment parseComment(XMLEventReader eventReader) {
        Comment cmt = new Comment();
        try {
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    String s = ((StartElement)event).getName().toString();
                    if (s.equals("who")) {
                        cmt.setAuthor(this.getAuthor(eventReader, event));
                    }
                    if (s.equals("bug_when")) {
                        cmt.setTimestamp(this.getTimestamp(this.getEventData(eventReader)));
                    }
                    if (!s.equals("thetext")) continue;
                    XMLEvent e = eventReader.nextEvent();
                    String ss = "";
                    if (e.isCharacters()) {
                        ss = ((Characters)e).getData();
                    }
                    cmt.setText(ss);
                    continue;
                }
                if (!event.isEndElement() || !((EndElement)event).getName().toString().equals("long_desc")) {
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e2) {
            e2.printStackTrace();
        }
        this.comments.add(cmt);
        return cmt;
    }

    private Long getTimestamp(String date) {
        SimpleDateFormat dateFormat = null;
        dateFormat = date.length() == "yyyy-MM-dd".length() ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        Date parsedDate = null;
        try {
            parsedDate = dateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (parsedDate != null) {
            return parsedDate.getTime();
        }
        return Long.MAX_VALUE;
    }

    public final void extractAllBugsHistories() {
        CreateSource.LOGGER.info("Getting issue events ..");
        for (IssueData i : this.issues) {
            try {
                List<Event> history = this.extractBugEvents(i.getNativeId());
                Thread.sleep(1500L);
                System.out.print(".");
                this.issueEvents.addAll(history);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println();
    }

    public final List<Event> extractBugEvents(int bugNumber) {
        ArrayList<Event> history = new ArrayList<Event>();
        String bugHistoryUrl = String.valueOf(this.baseUrl) + BUGZILLA_SHOW_ACTIVITY_TOKKEN + bugNumber;
        try {
            Document doc = Jsoup.connect((String)bugHistoryUrl).timeout(30000).get();
            Element element = doc.getElementById("bugzilla-body");
            for (Element table : element.select("table")) {
                Author author = null;
                String when = "";
                for (Element row : table.select("tr")) {
                    String vnew;
                    String old;
                    String what;
                    Elements tds = row.select("td");
                    Event event = new Event();
                    Metadata data = new Metadata();
                    event.getData().add(data);
                    data.getMetadata().put("issueId", String.valueOf(bugNumber));
                    if (tds.size() == 5) {
                        author = this.getAuthorByName(tds.get(0).text());
                        event.getAuthors().add(author);
                        when = tds.get(1).text();
                        event.setTimestamp(this.getTimestamp(when));
                        what = tds.get(2).text();
                        old = tds.get(3).text();
                        vnew = tds.get(4).text();
                        data.getMetadata().put("field", what);
                        data.getMetadata().put("oldValue", old);
                        data.getMetadata().put("newValue", vnew);
                        this.checkFixEvent(bugNumber, when, what, vnew);
                        event.setNativeId(String.valueOf((long)bugNumber + this.getTimestamp(when)));
                        history.add(event);
                        continue;
                    }
                    if (tds.size() != 3) continue;
                    event.getAuthors().add(author);
                    event.setTimestamp(this.getTimestamp(when));
                    what = tds.get(0).text();
                    old = tds.get(1).text();
                    vnew = tds.get(2).text();
                    data.getMetadata().put("field", what);
                    data.getMetadata().put("oldValue", old);
                    data.getMetadata().put("newValue", vnew);
                    this.checkFixEvent(bugNumber, when, what, vnew);
                    event.setNativeId(String.valueOf((long)bugNumber + this.getTimestamp(when)));
                    history.add(event);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return history;
    }

    private void checkFixEvent(int bugNumber, String when, String what, String newValue) {
        if (what.equals("Resolution") && newValue.equals("FIXED")) {
            for (IssueData i : this.issues) {
                if (i.getNativeId() != bugNumber) continue;
                i.setClosedAt(this.getTimestamp(when));
            }
        }
    }

    private Author getAuthorByName(String alias) {
        for (Author aut : this.authors) {
            if (!aut.getName().equals(alias)) continue;
            return aut;
        }
        Author a = new Author();
        a.setNativeId(alias);
        a.setName(alias);
        return a;
    }

    public final List<IssueData> getIssues() {
        return this.issues;
    }

    public final void setIssues(List<IssueData> issues) {
        this.issues = issues;
    }

    public final List<Event> getIssueEvents() {
        return this.issueEvents;
    }

    public final void setIssueEvents(List<Event> issueEvents) {
        this.issueEvents = issueEvents;
    }
}

