/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.issues.tfs;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.link.Link;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeCollection;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEnd;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEndCollection;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.core.clients.workitem.revision.Revision;
import com.microsoft.tfs.core.clients.workitem.revision.RevisionField;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import fr.labri.harmony.Action;
import fr.labri.harmony.ActionKind;
import fr.labri.harmony.Author;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.NativeElementNotFound;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.issues.AbstractBugTrackerAdapter;
import fr.labri.harmony.source.issues.BugtrackerProducer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;

public class TFSWorkItemsAdapter
extends AbstractBugTrackerAdapter {
    protected WorkItemClient wiClient;
    protected Project wiProject;

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new BugtrackerProducer(new TFSWorkItemsAdapter(), config, task, factory);
    }

    @Override
    public void init(BugtrackerProducer producer, Source src) throws WorkspaceException {
        TFSTeamProjectCollection connection;
        super.init(producer, src);
        JsonNode config = producer.getConfig();
        UsernamePasswordCredentials credentials = null;
        JsonNode credentialsNode = config.get("credentials");
        if (credentialsNode != null) {
            JsonNode userNameNode = credentialsNode.get("user-name");
            JsonNode passwordNode = credentialsNode.get("password");
            if (userNameNode != null && passwordNode != null) {
                credentials = new UsernamePasswordCredentials(userNameNode.asText(), passwordNode.asText());
            }
        }
        try {
            connection = new TFSTeamProjectCollection(new URI(src.getUrl()), credentials);
        }
        catch (URISyntaxException e) {
            throw new WorkspaceException(e);
        }
        connection.ensureAuthenticated();
        JsonNode projectNameNode = config.get("project");
        if (projectNameNode != null) {
            this.wiProject = connection.getWorkItemClient().getProjects().get(projectNameNode.asText());
            this.wiClient = this.wiProject.getWorkItemClient();
        }
    }

    @Override
    public Set<Item> createItems(Source src) throws CreateSourceException {
        HashSet<Item> items = new HashSet<Item>();
        WorkItemCollection coll = this.wiClient.query("SELECT * from workitems");
        int[] nArray = coll.getIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int wiId = nArray[n2];
            WorkItem wi = this.wiClient.getWorkItemByID(wiId);
            Item item = this.getFactories().items.create(Integer.toString(wiId), src);
            Set<Event> events = this.parseRevisions(wi, src);
            for (Event e : events) {
                Action a = new Action();
                a.setKind(ActionKind.Edit);
                a.setItem(item);
                item.getActions().add(a);
                e.getActions().add(a);
                a.setEvent(e);
            }
            this.parseLinks(wi, src);
            items.add(item);
            ++n2;
        }
        src.getItems().addAll(items);
        return items;
    }

    private void parseLinks(WorkItem wi, Source src) {
        for (Link link : wi.getLinks()) {
            if (!(link instanceof RelatedLink)) continue;
            RelatedLink rLink = (RelatedLink)link;
            WorkItemLinkTypeCollection types = this.wiClient.getLinkTypes();
            WorkItemLinkTypeEndCollection endTypes = types.getLinkTypeEnds();
            WorkItemLinkTypeEnd end = endTypes.getByID(rLink.getWorkItemLinkTypeID());
            System.out.println(String.valueOf(wi.getTitle()) + "->" + end.getName() + "-> " + rLink.getDescription());
        }
    }

    private Set<Event> parseRevisions(WorkItem wi, Source src) {
        HashSet<Event> events = new HashSet<Event>();
        for (Revision rev : wi.getRevisions()) {
            Event event = this.getFactories().events.create(Integer.toString(rev.hashCode()), src, rev.getRevisionDate().getTime());
            Metadata metadata = new Metadata();
            RevisionField[] revisionFieldArray = rev.getFields();
            int n = revisionFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevisionField field = revisionFieldArray[n2];
                metadata.add(field.getReferenceName(), "" + field.getValue());
                ++n2;
            }
            RevisionField authorField = rev.getField("System.ChangedBy");
            if (authorField != null && authorField.getValue() != null) {
                Author author;
                String authorName = authorField.getValue().toString();
                try {
                    author = (Author)this.getFactories().authors.tryGet(authorName);
                }
                catch (NativeElementNotFound e) {
                    author = this.getFactories().authors.create(authorName, src, authorName);
                }
                event.getAuthors().add(author);
                author.getEvents().add(event);
            }
            event.getData().add(metadata);
            metadata.setHarmonyElement(event);
            events.add(event);
        }
        src.getEvents().addAll(events);
        return events;
    }
}

