/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs;

import fr.labri.harmony.Event;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.VCSAdapter;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;

public class CreateVCSSource
extends CreateSource {
    private VCSAdapter adapter;

    public CreateVCSSource(VCSAdapter adapter, JsonNode config, SourceAnalysis analysis, SessionFactory factory) {
        super(config, analysis, factory);
        this.adapter = adapter;
    }

    @Override
    public Source createSource() throws CreateSourceException, WorkspaceException {
        Source src = new Source();
        CreateSource.LOGGER.info("Initializing source: " + this.config.get("url") + ".");
        this.adapter.init(this, src);
        CreateSource.LOGGER.info("Starting events processing for source: " + this.config.get("url") + ".");
        Event[] events = this.adapter.createEvents(src);
        CreateSource.LOGGER.info("Created " + events.length + " events for source: " + this.config.get("url") + ".");
        CreateSource.LOGGER.info("Starting processing of actions on source: " + this.config.get("url").asText());
        Event[] eventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Event e = eventArray[n2];
            this.adapter.createActions(src, e);
            ++n2;
        }
        CreateSource.LOGGER.info("Finished processing of actions on source: " + this.config.get("url").asText());
        return src;
    }
}

