/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.bzr;

import fr.labri.harmony.Event;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.VCSAdapter;
import fr.labri.harmony.source.vcs.bzr.BzrChangeset;
import fr.labri.harmony.source.vcs.bzr.BzrRepoFacade;
import fr.labri.harmony.source.vcs.bzr.NativeBzrWorkspace;
import fr.labri.harmony.utils.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class NativeBzrAdapter
extends VCSAdapter {
    private Map<Integer, BzrChangeset> revs = new HashMap<Integer, BzrChangeset>();
    private BzrRepoFacade bzrRepo;
    private NativeBzrWorkspace workspace;

    public NativeBzrAdapter(Source source, String localPath, String url, String user, String password, String remotePath) {
        this.cloneRepo(url, localPath);
        this.bzrRepo = new BzrRepoFacade(localPath);
    }

    private void cloneRepo(String url, String path) {
    }

    public void scan() {
        try {
            List<BzrChangeset> result = this.bzrRepo.getLog();
            for (BzrChangeset cset : result) {
                int revNo = cset.getRevNo();
                this.revs.put(revNo, cset);
                HashSet<String> parents = new HashSet<String>();
                for (BzrChangeset p : cset.getParents()) {
                    parents.add(p.getRevId());
                }
                this.scanFiles(cset.getRevNo(), cset.getRevId());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void scanFiles(int revNo, String revId) {
    }

    @Override
    public void init(CreateVCSSource producer, Source src) throws WorkspaceException {
        this.factories = producer.getFactories();
        this.workspace = new NativeBzrWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder()));
        this.workspace.init();
    }

    @Override
    public Event[] createEvents(Source src) throws CreateSourceException {
        return null;
    }

    @Override
    public void createActions(Source src, Event e) throws CreateSourceException {
    }
}

