/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.git;

import fr.labri.harmony.Author;
import fr.labri.harmony.Data;
import fr.labri.harmony.Event;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.NativeElementNotFound;
import fr.labri.harmony.Source;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.git.JGitAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import org.codehaus.jackson.JsonNode;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.hibernate.SessionFactory;

public class GitMasterVCSAdapter
extends JGitAdapter {
    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new CreateVCSSource(new GitMasterVCSAdapter(), config, task, factory);
    }

    @Override
    public Event[] createEvents(Source src) throws CreateSourceException {
        try {
            Metadata metadata;
            ArrayList<Event> events = new ArrayList<Event>();
            RevWalk w = new RevWalk(this.workspace.getGit().getRepository());
            w.sort(RevSort.TOPO, true);
            w.sort(RevSort.REVERSE, true);
            Ref master = this.workspace.getGit().getRepository().getRef("master");
            if (master == null) {
                CreateSource.LOGGER.info("No master branch for source " + this.workspace.getUrl() + ".");
                return new Event[0];
            }
            w.markStart(w.parseCommit((AnyObjectId)master.getObjectId()));
            for (RevCommit c : w) {
                this.revs.put(c.getName(), c);
                Event e = this.factories.events.create(c.getName(), src, c.getCommitTime());
                src.getEvents().add(e);
                events.add(e);
                metadata = new Metadata();
                metadata.getMetadata().put("COMMIT_LOG", c.getFullMessage());
                metadata.getMetadata().put("author", c.getAuthorIdent().getName());
                metadata.getMetadata().put("commiter", c.getCommitterIdent().getName());
                e.getData().add(metadata);
                metadata.setHarmonyElement(e);
                HashSet<Event> parents = new HashSet<Event>();
                RevCommit[] revCommitArray = c.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit parent = revCommitArray[n2];
                    parents.add((Event)this.factories.events.get(parent.getName()));
                    ++n2;
                }
                e.setParents(parents);
                HashSet<Author> authors = new HashSet<Author>();
                String user = c.getAuthorIdent().getName();
                Author author = null;
                try {
                    author = (Author)this.factories.authors.tryGet(user);
                }
                catch (NativeElementNotFound ne) {
                    author = this.factories.authors.create(user, src, user);
                }
                authors.add(author);
                e.setAuthors(authors);
                author.getEvents().add(e);
            }
            try {
                Event event = (Event)this.factories.events.tryGet(master.getTarget().getObjectId().name());
                for (Data d : event.getData()) {
                    if (!(d instanceof Metadata)) continue;
                    metadata = (Metadata)d;
                    metadata.getMetadata().put("HEAD", "master");
                }
            }
            catch (NativeElementNotFound e) {
                e.printStackTrace();
            }
            return events.toArray(new Event[events.size()]);
        }
        catch (Exception e) {
            throw new CreateSourceException(e);
        }
    }
}

