/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.git;

import fr.labri.harmony.Action;
import fr.labri.harmony.ActionKind;
import fr.labri.harmony.Author;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.NativeElementNotFound;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.VCSAdapter;
import fr.labri.harmony.source.vcs.git.JGitWorkspace;
import fr.labri.harmony.utils.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.hibernate.SessionFactory;

public class JGitAdapter
extends VCSAdapter {
    protected JGitWorkspace workspace;
    protected Map<String, RevCommit> revs = new HashMap<String, RevCommit>();

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new CreateVCSSource(new JGitAdapter(), config, task, factory);
    }

    @Override
    public void init(CreateVCSSource producer, Source src) throws WorkspaceException {
        this.factories = producer.getFactories();
        this.workspace = new JGitWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder()));
        this.workspace.init();
    }

    @Override
    public Event[] createEvents(Source src) throws CreateSourceException {
        try {
            ArrayList<Event> events = new ArrayList<Event>();
            RevWalk w = new RevWalk(this.workspace.getGit().getRepository());
            w.sort(RevSort.TOPO, true);
            w.sort(RevSort.REVERSE, true);
            for (Ref ref : this.workspace.getGit().getRepository().getAllRefs().values()) {
                w.markStart(w.parseCommit((AnyObjectId)ref.getObjectId()));
            }
            for (RevCommit c : w) {
                this.revs.put(c.getName(), c);
                Event e = this.factories.events.create(c.getName(), src, c.getCommitTime());
                events.add(e);
                Metadata metadata = new Metadata();
                metadata.getMetadata().put("commit_log", c.getFullMessage());
                metadata.getMetadata().put("COMMITER", c.getCommitterIdent().getName());
                e.getData().add(metadata);
                metadata.setHarmonyElement(e);
                HashSet<Event> parents = new HashSet<Event>();
                RevCommit[] revCommitArray = c.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit parent = revCommitArray[n2];
                    parents.add((Event)this.factories.events.get(parent.getName()));
                    ++n2;
                }
                e.setParents(parents);
                HashSet<Author> authors = new HashSet<Author>();
                String user = c.getAuthorIdent().getName();
                Author author = null;
                try {
                    author = (Author)this.factories.authors.tryGet(user);
                }
                catch (NativeElementNotFound ne) {
                    author = this.factories.authors.create(user, src, user);
                }
                authors.add(author);
                e.setAuthors(authors);
                author.getEvents().add(e);
            }
            return events.toArray(new Event[events.size()]);
        }
        catch (Exception e) {
            throw new CreateSourceException(e);
        }
    }

    @Override
    public void createActions(Source src, Event e) throws CreateSourceException {
        try {
            DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            df.setRepository(this.workspace.getGit().getRepository());
            df.setDiffComparator(RawTextComparator.DEFAULT);
            df.setDetectRenames(false);
            if (e.getParents().size() == 0) {
                TreeWalk w = new TreeWalk(this.workspace.getGit().getRepository());
                w.addTree((AnyObjectId)this.revs.get(e.getNativeId()).getTree());
                List entries = df.scan((AbstractTreeIterator)new EmptyTreeIterator(), w.getTree(0, AbstractTreeIterator.class));
                for (DiffEntry d : entries) {
                    this.extractAction(d, e, src);
                }
            } else {
                for (Event p : e.getParents()) {
                    List entries = df.scan(this.revs.get(p.getNativeId()).getTree(), this.revs.get(e.getNativeId()).getTree());
                    for (DiffEntry d : entries) {
                        Action a = this.extractAction(d, e, src);
                        a.setParentEvent(p);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new CreateSourceException(ex);
        }
    }

    private Action extractAction(DiffEntry d, Event e, Source src) {
        String path = d.getNewPath();
        Action a = new Action();
        Item i = null;
        try {
            i = (Item)this.factories.items.tryGet(path);
        }
        catch (NativeElementNotFound ne) {
            i = this.factories.items.create(path, src);
        }
        a.setEvent(e);
        e.getActions().add(a);
        a.setItem(i);
        i.getActions().add(a);
        ActionKind kind = null;
        switch (d.getChangeType()) {
            case ADD: {
                kind = ActionKind.Create;
                break;
            }
            case DELETE: {
                kind = ActionKind.Delete;
                path = d.getOldPath();
                break;
            }
            case MODIFY: {
                kind = ActionKind.Edit;
                break;
            }
            case COPY: {
                kind = ActionKind.Create;
                break;
            }
            case RENAME: {
                kind = ActionKind.Create;
                break;
            }
        }
        a.setKind(kind);
        return a;
    }
}

