/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.git;

import fr.labri.harmony.Event;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.vcs.VCSWorkspace;
import java.io.File;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;

public class JGitWorkspace
extends VCSWorkspace {
    private Git git;

    public JGitWorkspace(Source src, String url, String path) {
        super(src, url, path);
    }

    public Git getGit() {
        return this.git;
    }

    @Override
    public void doInit() throws WorkspaceException {
        try {
            this.git = ((CloneCommand)Git.cloneRepository().setURI(this.url).setDirectory(new File(this.path)).setTimeout(600)).call();
        }
        catch (Exception e) {
            throw new WorkspaceException(e);
        }
    }

    @Override
    public String doUpdate(Event e) throws WorkspaceException {
        try {
            CreateSource.LOGGER.fine("Updating source: " + this.url + " to event: " + e + ".");
            this.git.reset().setMode(ResetCommand.ResetType.HARD).setRef(e.getNativeId()).call();
            return this.path;
        }
        catch (Exception ex) {
            throw new WorkspaceException(ex);
        }
    }
}

