/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.git;

import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.git.NativeGitAdapter;
import fr.labri.harmony.utils.FileUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;

public class ShallowGitAdapter
extends NativeGitAdapter {
    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new CreateVCSSource(new ShallowGitAdapter(), config, task, factory);
    }

    @Override
    public void init(CreateVCSSource producer, Source src) throws WorkspaceException {
        this.factories = producer.getFactories();
        this.workspace = new GitWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder()));
        this.workspace.init();
    }

    protected static class GitWorkspace
    extends NativeGitAdapter.NativeGitWorkspace {
        public GitWorkspace(Source src, String url, String path) {
            super(src, url, path);
        }

        @Override
        public void doInit() throws WorkspaceException {
            try {
                URL u = new URL(this.url);
                HttpURLConnection huc = (HttpURLConnection)u.openConnection();
                huc.setRequestMethod("GET");
                huc.connect();
                int code = huc.getResponseCode();
                if (code < 400) {
                    ProcessBuilder b = new ProcessBuilder("git", "clone", "-q", "--depth=1", this.url, this.fpath.getAbsolutePath());
                    b.inheritIO();
                    Process p = b.start();
                    p.waitFor();
                    p.destroy();
                }
            }
            catch (Exception e) {
                throw new WorkspaceException(e);
            }
        }
    }
}

