/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.svn;

import fr.labri.harmony.Action;
import fr.labri.harmony.ActionKind;
import fr.labri.harmony.Author;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.NativeElementNotFound;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.VCSAdapter;
import fr.labri.harmony.source.vcs.VCSWorkspace;
import fr.labri.harmony.source.vcs.svn.SVNLogExtractor;
import fr.labri.harmony.utils.FileUtils;
import fr.labri.harmony.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNKitAdapter
extends VCSAdapter {
    private String remotePath;
    private SVNWorkspace workspace;

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new CreateVCSSource(new SVNKitAdapter(), config, task, factory);
    }

    @Override
    public void init(CreateVCSSource producer, Source src) throws WorkspaceException {
        this.factories = producer.getFactories();
        this.workspace = new SVNWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder()));
        this.workspace.init();
        this.remotePath = this.workspace.getRemotePath();
    }

    @Override
    public Event[] createEvents(Source src) throws CreateSourceException {
        try {
            SVNLogExtractor history = this.workspace.getHistory();
            ArrayList<Pair<Long, String>> revisions = new ArrayList<Pair<Long, String>>();
            ArrayList<Long> mapKeys = new ArrayList<Long>(history.getRevisions());
            Collections.sort(mapKeys);
            Long lastRev = history.getFirstRevision();
            ArrayList<Event> events = new ArrayList<Event>();
            Iterator iterator = mapKeys.iterator();
            while (iterator.hasNext()) {
                long rev = (Long)iterator.next();
                long ts = history.getTimestamp(rev);
                Event e = this.factories.events.create(Long.toString(rev), src, ts);
                events.add(e);
                HashSet<Event> parents = new HashSet<Event>();
                if (rev != history.getFirstRevision()) {
                    parents.add((Event)this.factories.events.get(Long.toString(lastRev)));
                }
                e.setParents(parents);
                HashSet<Author> authors = new HashSet<Author>();
                String user = history.getAuthor(rev);
                if (user == null) {
                    user = "anonymous";
                }
                Author author = null;
                try {
                    author = (Author)this.factories.authors.tryGet(user);
                }
                catch (NativeElementNotFound ne) {
                    author = this.factories.authors.create(user, src, user);
                }
                authors.add(author);
                e.setAuthors(authors);
                author.getEvents().add(e);
                Metadata metadata = new Metadata();
                metadata.getMetadata().put("commit_log", history.getCommitLog(rev));
                metadata.setHarmonyElement(e);
                e.getData().add(metadata);
                revisions.add(new Pair<Long, String>(rev, history.getAuthor(rev)));
                lastRev = rev;
            }
            return events.toArray(new Event[events.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CreateSourceException(ex);
        }
    }

    @Override
    public void createActions(Source src, Event e) throws CreateSourceException {
        for (SVNLogEntryPath entry : this.workspace.getHistory().getEntries(Long.parseLong(e.getNativeId()))) {
            Action a;
            Item i;
            String path = this.fixPath(entry.getPath());
            String oldPath = entry.getCopyPath();
            oldPath = oldPath == null ? path : this.fixPath(entry.getCopyPath());
            Event parent = null;
            if (e.getParents().iterator().hasNext()) {
                parent = e.getParents().iterator().next();
            }
            ActionKind kind = null;
            switch (entry.getType()) {
                case 'M': {
                    kind = ActionKind.Edit;
                    break;
                }
                case 'A': {
                    kind = ActionKind.Create;
                    break;
                }
                case 'D': {
                    kind = ActionKind.Delete;
                    break;
                }
                case 'R': {
                    kind = ActionKind.Delete;
                    i = null;
                    try {
                        i = (Item)this.factories.items.tryGet(oldPath);
                    }
                    catch (NativeElementNotFound ne) {
                        i = this.factories.items.create(oldPath, src);
                    }
                    a = new Action(i, kind, e, parent);
                    e.getActions().add(a);
                    i.getActions().add(a);
                    kind = ActionKind.Create;
                    break;
                }
            }
            if (kind == null) continue;
            i = null;
            try {
                i = (Item)this.factories.items.tryGet(path);
            }
            catch (NativeElementNotFound ne) {
                i = this.factories.items.create(path, src);
            }
            a = new Action(i, kind, e, parent);
            e.getActions().add(a);
            a.setEvent(e);
            i.getActions().add(a);
            a.setItem(i);
        }
    }

    protected String fixPath(String path) {
        if (path.startsWith(this.remotePath)) {
            return path.substring(this.remotePath.length(), path.length());
        }
        return path;
    }

    public boolean isIncluded(String path) {
        if (path == null) {
            return false;
        }
        if (this.remotePath == null) {
            return true;
        }
        return path.startsWith(this.remotePath);
    }

    private static final class SVNWorkspace
    extends VCSWorkspace {
        private SVNClientManager svn;
        private SVNLogExtractor history;
        private String remotePath;

        public String getRemotePath() {
            return this.remotePath;
        }

        private SVNWorkspace(Source src, String url, String path) {
            super(src, url, path);
        }

        @Override
        public void doInit() throws WorkspaceException {
            try {
                this.svn = SVNClientManager.newInstance((DefaultSVNOptions)new DefaultSVNOptions(), (String)"", (String)"");
                FSRepositoryFactory.setup();
                DAVRepositoryFactory.setup();
                SVNRepositoryFactoryImpl.setup();
                SVNURL surl = SVNURL.parseURIEncoded((String)this.url);
                this.svn.createRepository(surl, false);
                this.remotePath = surl.getURIEncodedPath().substring(surl.removePathTail().getURIEncodedPath().length());
                this.history = new SVNLogExtractor();
                this.svn.getLogClient().doLog(surl, new String[0], SVNRevision.HEAD, SVNRevision.create((long)0L), SVNRevision.HEAD, true, true, false, -1L, new String[0], (ISVNLogEntryHandler)this.history);
                this.svn.getUpdateClient().doCheckout(surl, new File(this.path), SVNRevision.create((long)this.history.getFirstRevision()), SVNRevision.create((long)this.history.getFirstRevision()), SVNDepth.INFINITY, true);
            }
            catch (SVNException e) {
                throw new WorkspaceException((Exception)((Object)e));
            }
        }

        private SVNLogExtractor getHistory() {
            return this.history;
        }

        @Override
        public String doUpdate(Event e) throws WorkspaceException {
            try {
                long rev = Long.parseLong(e.getNativeId());
                this.svn.getUpdateClient().doUpdate(new File(this.path), SVNRevision.create((long)rev), SVNDepth.INFINITY, true, true);
            }
            catch (SVNException ex) {
                throw new WorkspaceException((Exception)((Object)ex));
            }
            return this.path;
        }
    }
}

