/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.svn;

import fr.labri.harmony.source.vcs.svn.SVNLogEntryComparator;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class SVNLogExtractor
implements ISVNLogEntryHandler {
    private Map<Long, List<SVNLogEntryPath>> entries = new HashMap<Long, List<SVNLogEntryPath>>();
    private Map<Long, String> authors = new HashMap<Long, String>();
    private Map<Long, String> commitLogs;
    private SortedSet<Long> revisions;
    private Map<Long, Long> timestamps = new HashMap<Long, Long>();

    public long getFirstRevision() {
        return this.getRevisions().first();
    }

    public long getLastRevision() {
        return this.getRevisions().last();
    }

    public long getSize() {
        return this.getRevisions().size();
    }

    public SortedSet<Long> getRevisions() {
        if (this.revisions == null) {
            this.revisions = new TreeSet<Long>(this.entries.keySet());
        }
        return this.revisions;
    }

    public List<SVNLogEntryPath> getEntries(long revision) {
        return this.entries.get(revision);
    }

    public String getAuthor(long rev) {
        return this.authors.get(rev);
    }

    public long getTimestamp(long rev) {
        return this.timestamps.get(rev);
    }

    public String getCommitLog(long rev) {
        return this.commitLogs.get(rev);
    }

    public SVNLogExtractor() {
        this.commitLogs = new HashMap<Long, String>();
    }

    public void handleLogEntry(SVNLogEntry e) throws SVNException {
        Set changedPathsSet = e.getChangedPaths().keySet();
        this.entries.put(e.getRevision(), new LinkedList());
        this.authors.put(e.getRevision(), e.getAuthor());
        this.timestamps.put(e.getRevision(), e.getDate().getTime());
        this.commitLogs.put(e.getRevision(), e.getMessage());
        Calendar cal = Calendar.getInstance();
        cal.setTime(e.getDate());
        Iterator changedPaths = changedPathsSet.iterator();
        while (changedPaths.hasNext()) {
            SVNLogEntryPath entryPath = (SVNLogEntryPath)e.getChangedPaths().get(changedPaths.next());
            this.entries.get(e.getRevision()).add(entryPath);
        }
        Collections.sort(this.entries.get(e.getRevision()), new SVNLogEntryComparator());
    }
}

