/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import fr.labri.harmony.Action;
import fr.labri.harmony.ActionKind;
import fr.labri.harmony.Author;
import fr.labri.harmony.Event;
import fr.labri.harmony.Item;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.NativeElementNotFound;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.CreateSource;
import fr.labri.harmony.source.CreateSourceException;
import fr.labri.harmony.source.SourceAnalysis;
import fr.labri.harmony.source.vcs.CreateVCSSource;
import fr.labri.harmony.source.vcs.VCSAdapter;
import fr.labri.harmony.source.vcs.tfs.TFSWorkspace;
import fr.labri.harmony.utils.FileUtils;
import java.util.HashSet;
import org.codehaus.jackson.JsonNode;
import org.hibernate.SessionFactory;

public class TFSAdapter
extends VCSAdapter {
    protected TFSWorkspace workspace;

    public static CreateSource newInstance(JsonNode config, SourceAnalysis task, SessionFactory factory) {
        return new CreateVCSSource(new TFSAdapter(), config, task, factory);
    }

    @Override
    public void init(CreateVCSSource producer, Source src) throws WorkspaceException {
        this.factories = producer.getFactories();
        JsonNode config = producer.getConfig();
        JsonNode serverPathNode = config.get("server-path");
        String serverPath = "";
        if (serverPathNode != null) {
            serverPath = serverPathNode.asText();
        }
        UsernamePasswordCredentials credentials = null;
        JsonNode credentialsNode = config.get("credentials");
        if (credentialsNode != null) {
            JsonNode userNameNode = credentialsNode.get("user-name");
            JsonNode passwordNode = credentialsNode.get("password");
            if (userNameNode != null && passwordNode != null) {
                credentials = new UsernamePasswordCredentials(userNameNode.asText(), passwordNode.asText());
            }
        }
        this.workspace = new TFSWorkspace(src, producer.getURL(), FileUtils.createTmpFolder(producer.getTmpFolder()), serverPath, (Credentials)credentials);
        this.workspace.init();
    }

    @Override
    public Event[] createEvents(Source src) throws CreateSourceException {
        Changeset[] changesets = this.workspace.getChangeset();
        Event[] events = new Event[changesets.length];
        int i = 0;
        while (i < changesets.length) {
            Event e;
            Changeset changeset = changesets[i];
            int eventId = changeset.getChangesetID();
            long eventTime = changeset.getDate().getTimeInMillis() / 10L;
            events[i] = e = this.factories.events.create(Integer.toString(eventId), src, eventTime);
            Metadata metadata = new Metadata();
            metadata.getMetadata().put("commit_log", changeset.getComment());
            metadata.getMetadata().put("committer", changeset.getCommitter());
            metadata.getMetadata().put("committer-display-name", changeset.getCommitterDisplayName());
            e.getData().add(metadata);
            metadata.setHarmonyElement(e);
            HashSet<Author> authors = new HashSet<Author>();
            Author author = null;
            String userName = changeset.getOwner();
            String displayName = changeset.getOwnerDisplayName();
            try {
                author = (Author)this.factories.authors.tryGet(userName);
            }
            catch (NativeElementNotFound ne) {
                author = this.factories.authors.create(userName, src, displayName);
            }
            authors.add(author);
            e.setAuthors(authors);
            author.getEvents().add(e);
            HashSet<Event> parents = new HashSet<Event>();
            if (i != 0) {
                parents.add(events[i - 1]);
            }
            e.setParents(parents);
            ++i;
        }
        return events;
    }

    @Override
    public void createActions(Source src, Event e) throws CreateSourceException {
        Change[] changes;
        Changeset changeset = this.workspace.getTfsClient().getChangeset(Integer.parseInt(e.getNativeId()));
        Change[] changeArray = changes = changeset.getChanges();
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            Action a = new Action();
            Item i = null;
            if (change.getItem().getItemType().equals((Object)ItemType.FILE)) {
                String itemId = Integer.toString(change.getItem().getItemID());
                try {
                    i = (Item)this.factories.items.tryGet(itemId);
                }
                catch (NativeElementNotFound ne) {
                    i = this.factories.items.create(itemId, src);
                }
                a.setEvent(e);
                e.getActions().add(a);
                a.setItem(i);
                i.getActions().add(a);
                ActionKind kind = null;
                ChangeType changeType = change.getChangeType();
                if (changeType.contains(ChangeType.ADD)) {
                    kind = ActionKind.Create;
                } else if (changeType.contains(ChangeType.EDIT)) {
                    kind = ActionKind.Edit;
                } else if (changeType.contains(ChangeType.DELETE)) {
                    kind = ActionKind.Delete;
                }
                a.setKind(kind);
                String serverPath = change.getItem().getServerItem();
                Metadata metadata = new Metadata();
                metadata.getMetadata().put("server-path", serverPath);
                i.getData().add(metadata);
                metadata.setHarmonyElement(i);
            }
            ++n2;
        }
    }
}

