/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.source.vcs.tfs;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissionProfile;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.httpclient.Credentials;
import fr.labri.harmony.Event;
import fr.labri.harmony.Source;
import fr.labri.harmony.WorkspaceException;
import fr.labri.harmony.source.vcs.VCSWorkspace;
import java.net.URI;

public class TFSWorkspace
extends VCSWorkspace {
    protected String serverPath;
    protected VersionControlClient tfsClient;
    protected Credentials credentials;
    protected Workspace tfsWorkspace;

    public TFSWorkspace(Source src, String url, String path, String serverPath, Credentials credentials) {
        super(src, url, path);
        this.serverPath = serverPath;
        this.credentials = credentials;
    }

    @Override
    public void doInit() throws WorkspaceException {
        try {
            TFSTeamProjectCollection connection = new TFSTeamProjectCollection(new URI(this.url), this.credentials);
            connection.authenticate();
            this.tfsClient = connection.getVersionControlClient();
            this.tfsWorkspace = this.tfsClient.tryGetWorkspace(this.path);
            if (this.tfsWorkspace == null) {
                this.tfsWorkspace = this.tfsClient.createWorkspace(null, "HarmonyWorkspace", "Harmony temporary workspace", WorkspaceLocation.SERVER, null, WorkspacePermissionProfile.getPrivateProfile());
                WorkingFolder workingFolder = new WorkingFolder(this.serverPath, this.path);
                this.tfsWorkspace.createWorkingFolder(workingFolder);
            }
        }
        catch (Exception e) {
            throw new WorkspaceException(e);
        }
    }

    public VersionControlClient getTfsClient() {
        return this.tfsClient;
    }

    @Override
    public String doUpdate(Event e) throws WorkspaceException {
        ChangesetVersionSpec version = new ChangesetVersionSpec(Integer.parseInt(e.getNativeId()));
        this.tfsWorkspace.get((VersionSpec)version, GetOptions.OVERWRITE);
        return this.path;
    }

    public Changeset[] getChangeset() {
        return this.tfsClient.queryHistory(this.serverPath, (VersionSpec)LatestVersionSpec.INSTANCE, 0, RecursionType.FULL, "", null, (VersionSpec)LatestVersionSpec.INSTANCE, Integer.MAX_VALUE, true, false, false, true);
    }

    @Override
    public void clean() throws WorkspaceException {
        this.tfsClient.deleteWorkspace(this.tfsWorkspace);
        super.clean();
    }
}

