/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.utils;

import fr.labri.harmony.Data;
import fr.labri.harmony.Event;
import fr.labri.harmony.Metadata;
import fr.labri.harmony.Source;
import fr.labri.harmony.utils.EventComparator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.codehaus.jackson.JsonNode;

public class EventSelector {
    private int eventStep;
    private String eventStepUnit;
    private String eventSort;
    private boolean oneBranch;
    private Source source;

    public EventSelector(Source src, JsonNode config) {
        this.source = src;
        JsonNode options = config.get("options");
        this.eventStep = options != null && options.has("event_step") ? options.get("event_step").asInt(1) : 1;
        this.eventStepUnit = options != null && options.has("event_step_unit") ? options.get("event_step_unit").asText() : "EVENT";
        this.eventSort = options != null && options.has("event_sort") ? options.get("event_sort").asText() : "TIMESTAMP";
        this.oneBranch = options != null && options.has("one_branch") ? options.get("one_branch").asBoolean(false) : false;
    }

    public LinkedList<Event> getEvents() {
        LinkedList<Event> events;
        block17: {
            block15: {
                events = this.oneBranch ? this.cutOffBranches(this.source) : new LinkedList<Event>(this.source.getEvents());
                if (this.eventSort != "TIMESTAMP") break block15;
                Collections.sort(events, new EventComparator());
                switch (this.eventStepUnit) {
                    case "DAY": {
                        this.removeEvents(events, this.eventStep * 24 * 3600);
                        break;
                    }
                    case "MONTH": {
                        this.removeEvents(events, this.eventStep * 30 * 24 * 3600);
                        break;
                    }
                    case "LAST": {
                        LinkedList<Event> e = new LinkedList<Event>();
                        e.add(events.getLast());
                        events = e;
                        break;
                    }
                }
                break block17;
            }
            Collections.reverse(events);
            if (this.eventStep != 1) {
                LinkedList<Event> e = new LinkedList<Event>();
                int i = 0;
                while (i < events.size()) {
                    e.add(events.get(i));
                    i += this.eventStep;
                }
                events = e;
            }
        }
        return events;
    }

    private void removeEvents(LinkedList<Event> events, int step) {
        throw new RuntimeException("Not implemented yet!");
    }

    private LinkedList<Event> cutOffBranches(Source src) {
        return this.cutOffBranches(this.getHeadEvent(src));
    }

    private LinkedList<Event> cutOffBranches(Event event) {
        LinkedList<Event> events = new LinkedList<Event>();
        switch (event.getParents().size()) {
            case 0: {
                return events;
            }
            case 1: {
                events.addAll(this.cutOffBranches(event.getParents().iterator().next()));
                break;
            }
            default: {
                Iterator<Event> it = event.getParents().iterator();
                Event bestParent = it.next();
                while (it.hasNext()) {
                    Event parent = it.next();
                    if (event.getActions(parent).size() >= event.getActions(bestParent).size()) continue;
                    bestParent = parent;
                }
                events.addAll(this.cutOffBranches(bestParent));
            }
        }
        events.add(event);
        return events;
    }

    private Event getHeadEvent(Source src) {
        Set<Event> events = src.getEvents();
        for (Event event : events) {
            Set<Data> dataSet = event.getData();
            for (Data data : dataSet) {
                if (!(data instanceof Metadata) || ((Metadata)data).getMetadata().get("HEAD") == null) continue;
                return event;
            }
        }
        return null;
    }
}

