/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.utils;

import fr.labri.harmony.Action;
import fr.labri.harmony.Event;
import fr.labri.harmony.Source;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public final class VisualizeSource {
    private VisualizeSource() {
    }

    public static void toDotFile(Source src, String file) {
        try {
            FileWriter w = new FileWriter(file);
            w.append("digraph G {\n");
            for (Event e : src.getEvents()) {
                w.append("\t" + e.getId() + " [shape=record,label=\"{");
                w.append(e.toString());
                if (e.getActions().size() > 0) {
                    w.append("|");
                }
                Iterator<Action> aIt = e.getActions().iterator();
                while (aIt.hasNext()) {
                    Action a = aIt.next();
                    w.append(a.toString());
                    if (!aIt.hasNext()) continue;
                    w.append("\\n");
                }
                w.append("}\"];\n");
            }
            for (Event e : src.getEvents()) {
                for (Event p : e.getParents()) {
                    w.append("\t" + e.getId() + "->" + p.getId() + ";\n");
                }
            }
            w.append("}");
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void toHTMLFile(Source src, String file) {
        try {
            FileWriter w = new FileWriter(file);
            w.append("<!DOCTYPE html>");
            w.append("<html><head><meta charset=\"UTF8\"/ >\n<link href=\"http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/themes/base/jquery-ui.css\" rel=\"stylesheet\" type=\"text/css\"/>\n<script src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js\"></script>\n<script src=\"http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js\"></script>\n");
            w.append("<script>$(document).ready(function() { $(\"#accordion\").accordion(); });</script>\n");
            w.append("</head><body style=\"font-size:62.5%;\">\n");
            w.append("<h2>Source " + src.getUrl() + "</h2>\n");
            w.append("<div id=\"accordion" + src.getId() + "\">\n");
            LinkedList<Event> events = new LinkedList<Event>(src.getEvents());
            for (Event e : events) {
                w.append("<h3><a href=\"#\">");
                if (e.getParents().size() > 1) {
                    w.append("Merge ");
                } else {
                    w.append("Event ");
                }
                w.append(String.valueOf(e.getId()) + " (" + e + ")");
                w.append("</a></h3>\n");
                w.append("<div>\n");
                w.append("Parents: " + e.getParents() + "<br/>\n");
                w.append("Authors: " + e.getAuthors() + "<br/>\n");
                w.append("Date: " + new Date(e.getTimestamp()) + "<br/>\n");
                if (e.getActions().size() > 0) {
                    w.append("Modified items:<br/>\n<ul>\n");
                    for (Action a : e.getActions()) {
                        w.append("<li><i>" + a.getKind().name() + "</i>: " + a.getItem().getNativeId() + "</li>\n");
                    }
                    w.append("</ul>\n");
                }
                w.append("</div>\n");
            }
            w.append("</div></body></html>");
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

