/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.harmony.utils.jdt;

import fr.labri.harmony.Action;
import fr.labri.harmony.utils.jdt.ASTRequestor;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class ASTGenerator {
    private ASTVisitor visitor;
    protected JsonNode config;
    protected String localPath;
    private static Set<String> STANDARD_ROOT_PACKAGES = new HashSet<String>(Arrays.asList("fr", "de", "au", "net", "uk", "org", "com"));
    private static Set<String> MAVEN_ROOT_PACKAGES = new HashSet<String>(Arrays.asList("java", "main", "test"));
    private static Set<String> consistents = new HashSet<String>(Arrays.asList(".hg", ".svn", ".git"));
    private String[] classPath;
    private String[] sourcePath;
    private Set<String> excludesPackages;
    private Set<String> includesOnlyPackages;

    public ASTGenerator(String localPath, JsonNode config, ASTVisitor metrics) {
        this.localPath = localPath;
        this.config = config;
        this.updateConfiguration();
        this.visitor = metrics;
    }

    public ASTGenerator(String localPath) {
        this.localPath = localPath;
        this.updateConfiguration();
    }

    public ASTGenerator() {
        this.localPath = "";
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void generate(String[] files, String dir) {
        ASTParser parser = ASTParser.newParser((int)4);
        this.setLocalPath(dir);
        this.updateConfiguration();
        parser.setEnvironment(this.classPath, this.sourcePath, null, true);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        parser.setKind(8);
        Hashtable pOptions = JavaCore.getOptions();
        pOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
        pOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
        pOptions.put("org.eclipse.jdt.core.compiler.source", "1.7");
        parser.setCompilerOptions((Map)pOptions);
        ASTRequestor req = new ASTRequestor(this.visitor);
        parser.createASTs(files, null, new String[0], (FileASTRequestor)req, null);
    }

    public boolean handleFile(String file) {
        return file.endsWith(".java");
    }

    private void scanDirectory(String path, Set<String> jars, Set<String> sourceDirs, Set<String> rootPackages) {
        File current = new File(path).getAbsoluteFile();
        if (current.isDirectory()) {
            File[] list = current.listFiles();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    if (list[i].isDirectory()) {
                        String name = list[i].getName();
                        if (!consistents.contains(name)) {
                            if (rootPackages.contains(name)) {
                                if (list[i].getAbsolutePath().split("\\/").length > 2) {
                                    if (!consistents.contains(name)) {
                                        sourceDirs.add(list[i].getParentFile().getAbsolutePath());
                                    }
                                } else {
                                    sourceDirs.add(list[i].getParentFile().getAbsolutePath());
                                }
                            }
                            if (MAVEN_ROOT_PACKAGES.contains(name)) {
                                sourceDirs.add(list[i].getParentFile().getAbsolutePath());
                                this.scanDirectory(list[i].getAbsolutePath(), jars, sourceDirs, rootPackages);
                            } else {
                                this.scanDirectory(list[i].getAbsolutePath(), jars, sourceDirs, rootPackages);
                            }
                        }
                    } else if (list[i].getAbsolutePath().endsWith(".jar")) {
                        jars.add(list[i].getAbsolutePath());
                    }
                    ++i;
                }
            }
            list = null;
        }
    }

    public boolean modifyConfiguration(Action a) {
        String dir;
        if (a.getItem().getNativeId().endsWith(".jar")) {
            return true;
        }
        return !new File(String.valueOf(this.localPath) + "/" + a.getItem().getNativeId()).exists() && !(dir = new File(String.valueOf(this.localPath) + "/" + a.getItem().getNativeId()).getName()).contains(".");
    }

    public void updateConfiguration() {
        HashSet<String> jars = new HashSet<String>();
        HashSet<String> sourceDirs = new HashSet<String>();
        HashSet<String> rootPackages = new HashSet<String>();
        this.excludesPackages = new HashSet<String>();
        this.includesOnlyPackages = new HashSet<String>();
        if (this.config != null) {
            int i;
            String[] tmp;
            if (this.config.has("jdt.external-jars")) {
                tmp = this.config.get("jdt.external-jars").asText().split("\\,");
                i = 0;
                while (i < tmp.length) {
                    this.scanDirectory(tmp[i], jars, sourceDirs, rootPackages);
                    ++i;
                }
            }
            if (this.config.has("jdt.root-packages")) {
                tmp = this.config.get("jdt.root-packages").asText().split("\\,");
                i = 0;
                while (i < tmp.length) {
                    rootPackages.add(tmp[i]);
                    ++i;
                }
            }
            if (this.config.has("jdt.root-excluded")) {
                tmp = this.config.get("jdt.root-excluded").asText().split(",");
                i = 0;
                while (i < tmp.length) {
                    this.excludesPackages.add(tmp[i].replaceAll("\\*", ".\\*"));
                    ++i;
                }
            }
            if (this.config.has("jdt.root-only")) {
                tmp = this.config.get("jdt.root-only").asText().split(",");
                i = 0;
                while (i < tmp.length) {
                    this.includesOnlyPackages.add(tmp[i].replaceAll("\\*", ".\\*"));
                    ++i;
                }
            }
        }
        if (rootPackages.size() == 0) {
            rootPackages.addAll(STANDARD_ROOT_PACKAGES);
        }
        this.scanDirectory(this.localPath, jars, sourceDirs, rootPackages);
        this.classPath = new String[jars.size() + sourceDirs.size() + 1];
        int i = 0;
        Iterator iterator = jars.iterator();
        while (iterator.hasNext()) {
            String jar;
            this.classPath[i] = jar = (String)iterator.next();
            ++i;
        }
        this.classPath[i] = this.localPath;
        ++i;
        this.sourcePath = new String[sourceDirs.size() + 1];
        int j = 0;
        Iterator iterator2 = sourceDirs.iterator();
        while (iterator2.hasNext()) {
            String sourceDir;
            this.sourcePath[j] = sourceDir = (String)iterator2.next();
            this.classPath[i] = sourceDir;
            ++i;
            ++j;
        }
        this.sourcePath[j] = this.localPath;
    }

    public boolean checkClasspath() {
        String cl;
        String[] stringArray = this.classPath;
        int n = this.classPath.length;
        int n2 = 0;
        while (n2 < n) {
            cl = stringArray[n2];
            if (!new File(cl).exists()) {
                this.updateConfiguration();
                return false;
            }
            ++n2;
        }
        stringArray = this.sourcePath;
        n = this.sourcePath.length;
        n2 = 0;
        while (n2 < n) {
            cl = stringArray[n2];
            if (!new File(cl).exists()) {
                this.updateConfiguration();
                return false;
            }
            ++n2;
        }
        return true;
    }
}

