/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.ragelpp;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;

public class RagelX {
    private static final String RAGEL_HEADER = "ragel.h";
    private static final String LANG_HEADER = "spec.h";
    private static final String BODY_HEADER = "body.h";
    private static final String DEFAULT_MACHINE_NAME = "DefaultMachine";
    private static final String PREPROCESS_COMMAND = "gcc -E -P";
    private String _machine;
    private String _targetLanguage;

    public static void main(String[] args) throws IOException, URISyntaxException, InterruptedException {
        String targetLanguage = "java";
        InputStream in = System.in;
        String machine = DEFAULT_MACHINE_NAME;
        switch (args.length) {
            default: {
                targetLanguage = args[1];
            }
            case 1: {
                machine = RagelX.getName(args[0]);
                in = RagelX.openFile(args[0]);
            }
            case 0: 
        }
        new RagelX(machine, targetLanguage).compile(in, System.out);
    }

    public RagelX(String machine, String targetLang) throws IOException {
        this._machine = machine;
        this._targetLanguage = targetLang.toLowerCase();
        this.openLanguage(this._targetLanguage);
    }

    public void compile(InputStream in, final OutputStream out) throws IOException, InterruptedException {
        int r;
        MultipleFileInputStream i = new MultipleFileInputStream(new Object[]{RagelX.openRessource(RAGEL_HEADER), RagelX.openRessource(this._targetLanguage + "/" + LANG_HEADER), in, RagelX.openRessource(this._targetLanguage + "/" + BODY_HEADER)});
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(PREPROCESS_COMMAND.split(" ")));
        cmd.add("-D__MACHINE_NAME__=" + this._machine);
        cmd.add("-");
        final Process p = new ProcessBuilder(cmd).start();
        OutputStream o = p.getOutputStream();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new StreamWriter().transfert(new BufferedInputStream(p.getInputStream()), out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
        while ((r = ((InputStream)i).read()) > 0) {
            o.write(r);
        }
        i.close();
        o.close();
        p.waitFor();
        t.join();
    }

    public void callRagel(InputStream in, OutputStream out) throws IOException, InterruptedException {
        File f = File.createTempFile("ragelx", ".rl");
        this.compile(in, new FileOutputStream(f));
    }

    private void openLanguage(String name) throws IOException {
        InputStream lang = RagelX.openRessource(name + "/language");
        if (lang == null) {
            throw new FileNotFoundException(name);
        }
        lang.close();
    }

    public static InputStream openFile(String fname) throws FileNotFoundException {
        if ("-".equals(fname)) {
            return System.in;
        }
        return new FileInputStream(fname);
    }

    private static String getName(String name) {
        if ("-".equals(name)) {
            return DEFAULT_MACHINE_NAME;
        }
        return name;
    }

    public static void syntax() {
        System.err.println("bad command line");
    }

    static InputStream openRessource(String name) {
        return RagelX.class.getResourceAsStream("/" + name);
    }

    static class StreamWriter {
        StreamWriter() {
        }

        public void transfert(InputStream in, OutputStream out) throws IOException {
            int r;
            byte[] b = new byte[1024];
            while ((r = in.read(b)) > 0) {
                out.write(b, 0, r);
            }
        }
    }

    static class MultipleFileInputStream
    extends InputStream {
        int _current = 0;
        Object[] _files;
        InputStream _in;
        EOFException eof = new EOFException();

        MultipleFileInputStream(Object[] files) throws IOException {
            this._files = files;
            this.nextFile();
        }

        @Override
        public int read() throws IOException {
            try {
                int v = this._in.read();
                if (v == -1) {
                    throw this.eof;
                }
                return v;
            }
            catch (EOFException e) {
                try {
                    this.nextFile();
                    return this.read();
                }
                catch (EOFException ee) {
                    return -1;
                }
            }
        }

        private void nextFile() throws IOException {
            if (this._in != null) {
                this._in.close();
            }
            if (this._current >= this._files.length) {
                throw this.eof;
            }
            this._in = this.openFile(this._files[this._current++]);
        }

        private InputStream openFile(Object o) throws FileNotFoundException {
            if (o == null) {
                throw new FileNotFoundException("Null:" + Arrays.toString(this._files) + this._current);
            }
            if (o instanceof InputStream) {
                return (InputStream)o;
            }
            if (o instanceof String) {
                return new FileInputStream((String)o);
            }
            if (o instanceof File) {
                return new FileInputStream((File)o);
            }
            if (o instanceof URI) {
                return new FileInputStream(new File((URI)o));
            }
            if (o instanceof URL) {
                try {
                    return new FileInputStream(new File(((URL)o).toURI()));
                }
                catch (URISyntaxException e) {
                    throw new FileNotFoundException(e.toString());
                }
            }
            throw new FileNotFoundException(o.toString());
        }
    }
}

