/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import fr.labri.tima.ITimedAutomata;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;

public class AutomataViewer<C> {
    private final ITimedAutomata<C> _auto;

    public static JFrame viewAsFrame(ITimedAutomata<?> automata) {
        JFrame frame = new JFrame("Simple Graph View");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)new AutomataViewer(automata).asPanel());
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    AutomataViewer(ITimedAutomata<C> auto) {
        this._auto = auto;
    }

    BasicVisualizationServer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> asPanel() {
        DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> g = this.asGraph();
        FRLayout layout = new FRLayout(g);
        layout.setSize(new Dimension(300, 300));
        BasicVisualizationServer vv = new BasicVisualizationServer((Layout)layout);
        vv.setPreferredSize(new Dimension(350, 350));
        vv.getRenderContext().getPickedVertexState().pick(this._auto.getInitialState(), true);
        for (ITimedAutomata.Predicate e : g.getEdges()) {
            if (!(e instanceof DefaultTransition)) continue;
            vv.getRenderContext().getPickedEdgeState().pick((Object)e, true);
        }
        return vv;
    }

    DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> asGraph() {
        DirectedSparseGraph sgv = new DirectedSparseGraph();
        for (ITimedAutomata.State<C> state : this._auto.getStates()) {
            sgv.addVertex(state);
        }
        for (ITimedAutomata.State<C> state : this._auto.getStates()) {
            for (ITimedAutomata.State<C> dst : this._auto.getFollowers(state)) {
                final ITimedAutomata.Predicate<C> pred = this._auto.getPredicate(state, dst);
                int timeout = this._auto.getTimeout(state, dst);
                if (timeout != 0) {
                    sgv.addEdge((Object)new ITimedAutomata.Predicate<C>(){

                        @Override
                        public boolean isValid(C context, String key) {
                            return pred.isValid(context, key);
                        }

                        @Override
                        public String getType() {
                            return pred.getType();
                        }
                    }, state, dst);
                    continue;
                }
                sgv.addEdge(new DefaultTransition<C>(pred), state, dst);
            }
        }
        return sgv;
    }

    static class DefaultTransition<C>
    implements ITimedAutomata.Predicate<C> {
        final ITimedAutomata.Predicate<C> _pred;

        public DefaultTransition(ITimedAutomata.Predicate<C> pred) {
            this._pred = pred;
        }

        @Override
        public boolean isValid(C context, String key) {
            return this._pred.isValid(context, key);
        }

        @Override
        public String getType() {
            return this._pred.getType();
        }
    }
}

