/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import fr.labri.Utils;
import fr.labri.tima.ITimedAutomata;

public class DotRenderer<C> {
    public static final String INFINITY_SYMBOL = "+oo";
    public final ITimedAutomata<C> _auto;
    public final ITimedAutomata.State<C>[] _states;
    public final int start = 0;

    public DotRenderer(ITimedAutomata<C> auto) {
        this._auto = auto;
        this._states = auto.getStates();
    }

    public String toDot(String name) {
        StringBuilder b = new StringBuilder("digraph ").append(name).append(" {\nedge [splines=ortho];\n");
        for (ITimedAutomata.State<C> state : this._states) {
            b.append(this.getNodeID(state)).append(" [").append(this.getStateDecoration(state)).append("];\n");
            for (ITimedAutomata.State<C> dst : this._auto.getFollowers(state)) {
                if (dst == null) continue;
                b.append(this.getNodeID(state)).append(" -> ").append(this.getNodeID(dst)).append(" [").append(this.getTransitionDecoration(state, dst)).append("];\n");
            }
        }
        return b.append("};").toString();
    }

    private String getTransitionDecoration(ITimedAutomata.State<C> src, ITimedAutomata.State<C> dst) {
        StringBuilder b = new StringBuilder();
        int timeout = this._auto.getTimeout(src, dst);
        ITimedAutomata.Predicate<C> pred = this._auto.getPredicate(src, dst);
        String sep = "";
        if (pred != null) {
            b.append("label=\"").append(pred.getType()).append("\"");
            sep = ", ";
        }
        if (timeout != 0) {
            b.append(sep).append("taillabel=\"").append(timeout == -1 ? INFINITY_SYMBOL : Integer.toString(timeout)).append("\"");
            sep = ", ";
        }
        if (timeout == 0) {
            b.append(sep).append("style=dashed");
        }
        return b.toString();
    }

    public String getNodeID(ITimedAutomata.State<C> state) {
        return "node" + Integer.toString(0 + Utils.indexOf(state, this._states));
    }

    public String getNodeName(ITimedAutomata.State<C> state) {
        String name = state.getName();
        return name == null ? this.getNodeID(state) : name;
    }

    public String getStateDecoration(ITimedAutomata.State<C> state) {
        StringBuilder b = new StringBuilder();
        b.append("shape=\"record\", label=\"{").append(state.getName()).append("|{");
        String sep = "";
        for (ITimedAutomata.Action<C> a : state.getActions()) {
            b.append(sep).append(a.getType());
            sep = "|";
        }
        b.append("}}\"");
        int mod = state.getModifier();
        b.append(", style=\"filled");
        if ((mod & 1) > 0) {
            b.append(",diagonals");
        }
        if ((mod & 2) > 0) {
            b.append(",bold");
        }
        b.append("\"");
        if ((mod & 8) > 0) {
            b.append(", color=\"red\"");
        }
        if ((mod & 4) > 0) {
            b.append(", fillcolor=\"yellow\"");
        } else {
            b.append(", fillcolor=\"white\"");
        }
        return b.toString();
    }
}

