/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import fr.labri.tima.CompiledTimedAutomata;
import fr.labri.tima.DotRenderer;
import fr.labri.tima.ITimedAutomata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimedAutomata<C>
implements ITimedAutomata<C> {
    public static final int INFINITY = -1;
    public static final int TIMEOUT = 0;
    ITimedAutomata.State<C> _initial;
    final Map<ITimedAutomata.State<C>, List<Transition>> _transitions = new HashMap<ITimedAutomata.State<C>, List<Transition>>();
    final Set<ITimedAutomata.State<C>> _stateMap = new HashSet<ITimedAutomata.State<C>>();
    final Set<ITimedAutomata.Predicate<C>> _predMap = new HashSet<ITimedAutomata.Predicate<C>>();

    public void setInitial(ITimedAutomata.State<C> state) {
        this._initial = state;
    }

    public void addDefaultTransition(ITimedAutomata.State<C> from, ITimedAutomata.State<C> to) {
        this.addTransition(from, 0, null, to);
    }

    public void addTransition(ITimedAutomata.State<C> from, ITimedAutomata.Predicate<C> pred, ITimedAutomata.State<C> to) {
        this.addTransition(from, -1, pred, to);
    }

    void addTransition(ITimedAutomata.State<C> from, int timeout, ITimedAutomata.Predicate<C> pred, ITimedAutomata.State<C> to) {
        List<Transition> t = this._transitions.get(from);
        if (t == null) {
            t = new ArrayList<Transition>();
            this._transitions.put(from, t);
        }
        t.add(new Transition(timeout, pred, to));
        this._predMap.add(pred);
        this._stateMap.add(from);
        this._stateMap.add(to);
    }

    public ITimedAutomata<C> compile(ITimedAutomata.State<C> init) {
        this.setInitial(init);
        return this.compile();
    }

    public ITimedAutomata<C> compile() {
        if (this._initial == null) {
            throw new RuntimeException("Initial state not set");
        }
        return new Compiler().compile();
    }

    @Override
    public ITimedAutomata.Cursor<C> start(final ITimedAutomata.ContextProvider<C> context, final String key) {
        return new ITimedAutomata.Cursor<C>(){
            ITimedAutomata.State<C> _current;
            int _currentTime;

            @Override
            public ITimedAutomata<C> getAutomata() {
                return TimedAutomata.this;
            }

            @Override
            public final boolean next(ITimedAutomata.Executor<C> executor) {
                Object ctx = context.getContext();
                boolean allexpired = true;
                ITimedAutomata.State timeoutTarget = null;
                for (Transition trans : TimedAutomata.this._transitions.get(this._current)) {
                    int timeout = trans.timeout;
                    if (timeout == 0) {
                        timeoutTarget = trans.state;
                        continue;
                    }
                    if (this._currentTime >= timeout && timeout != -1) continue;
                    allexpired = false;
                    if (!trans.predicate.isValid(ctx, key)) continue;
                    this.setState(trans.state, executor, ctx);
                }
                ++this._currentTime;
                if (allexpired && timeoutTarget != null) {
                    this.setState(timeoutTarget, executor, ctx);
                }
                return (this._current.getModifier() & 8) > 0;
            }

            public final void setState(ITimedAutomata.State<C> target, ITimedAutomata.Executor<C> executor, C context2) {
                if (this._current == target) {
                    target.eachAction(context2, executor, key);
                } else {
                    this._current.postAction(context2, executor, key);
                    this._current = target;
                    this._currentTime = 0;
                    this._current.preAction(context2, executor, key);
                }
            }

            @Override
            public String getKey() {
                return key;
            }
        };
    }

    private ITimedAutomata.State<C>[] mapToStates(Map<ITimedAutomata.State<C>, Integer> map) {
        return this.mapTo(map, new ITimedAutomata.State[map.size()]);
    }

    private ITimedAutomata.Predicate<C>[] mapToPredicates(Map<ITimedAutomata.Predicate<C>, Integer> map) {
        return this.mapTo(map, new ITimedAutomata.Predicate[map.size()]);
    }

    private <T> T[] mapTo(Map<T, Integer> map, T[] array) {
        for (Map.Entry<T, Integer> e : map.entrySet()) {
            array[e.getValue().intValue()] = e.getKey();
        }
        return array;
    }

    private <T> int getIndex(T item, Map<T, Integer> index) {
        if (index.containsKey(item)) {
            return index.get(item);
        }
        int idx = index.size();
        index.put(item, idx);
        return idx;
    }

    public String toString() {
        return new DotRenderer(this).toDot("G");
    }

    @Override
    public final ITimedAutomata.State<C> getInitialState() {
        return this._initial;
    }

    @Override
    public final void setInitialState(ITimedAutomata.State<C> initial) {
        this._initial = initial;
    }

    @Override
    public final ITimedAutomata.State<C>[] getStates() {
        ITimedAutomata.State[] a = new ITimedAutomata.State[this._stateMap.size()];
        return this._stateMap.toArray(a);
    }

    @Override
    public ITimedAutomata.State<C>[] getFollowers(ITimedAutomata.State<C> src) {
        List<Transition> t = this._transitions.get(src);
        ITimedAutomata.State[] states = new ITimedAutomata.State[t.size()];
        for (int i = 0; i < t.size(); ++i) {
            states[i] = t.get((int)i).state;
        }
        return states;
    }

    @Override
    public int getTimeout(ITimedAutomata.State<C> src, ITimedAutomata.State<C> dst) {
        List<Transition> t = this._transitions.get(src);
        for (Transition trans : t) {
            if (trans.state != dst) continue;
            return trans.timeout;
        }
        return 0;
    }

    @Override
    public ITimedAutomata.Predicate<C> getPredicate(ITimedAutomata.State<C> src, ITimedAutomata.State<C> dst) {
        List<Transition> t = this._transitions.get(src);
        for (Transition trans : t) {
            if (trans.state != dst) continue;
            return trans.predicate;
        }
        return null;
    }

    class Next
    implements Iterable<Map.Entry<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>>> {
        final int deadline;
        ArrayList<ITimedAutomata.State<C>> states = new ArrayList();
        ArrayList<ITimedAutomata.Predicate<C>> trans = new ArrayList();

        Next(int t) {
            this.deadline = t;
        }

        void add(ITimedAutomata.State<C> s, ITimedAutomata.Predicate<C> t) {
            this.states.add(s);
            this.trans.add(t);
        }

        public String toString() {
            return "<" + this.deadline + "::" + this.states + this.trans + ">";
        }

        int size() {
            return this.states.size();
        }

        @Override
        public Iterator<Map.Entry<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>>> iterator() {
            return new Iterator<Map.Entry<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>>>(){
                int pos = 0;

                @Override
                public boolean hasNext() {
                    return this.pos < Next.this.states.size();
                }

                @Override
                public Map.Entry<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> next() {
                    return new Map.Entry<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>>(){

                        @Override
                        public ITimedAutomata.State<C> getKey() {
                            return Next.this.states.get(pos);
                        }

                        @Override
                        public ITimedAutomata.Predicate<C> getValue() {
                            return Next.this.trans.get(pos);
                        }

                        @Override
                        public ITimedAutomata.Predicate<C> setValue(ITimedAutomata.Predicate<C> value) {
                            return Next.this.trans.set(pos, value);
                        }
                    };
                }

                @Override
                public void remove() {
                    Next.this.states.remove(this.pos);
                    Next.this.trans.remove(this.pos);
                }
            };
        }
    }

    private final class Transition {
        final ITimedAutomata.Predicate<C> predicate;
        final int timeout;
        final ITimedAutomata.State<C> state;

        Transition(int time, ITimedAutomata.Predicate<C> t, ITimedAutomata.State<C> s) {
            this.timeout = time;
            this.state = s;
            this.predicate = t;
        }

        public String toString() {
            return "{" + this.predicate + "/" + this.timeout + "->" + this.state + "}";
        }
    }

    class Compiler {
        int[] timeouts;
        int[] timeoutTargets;
        int[][] transitionPredicates;
        int[][] transitionTarget;
        Map<ITimedAutomata.State<C>, List<Next>> newNodes;
        final Map<ITimedAutomata.State<C>, Integer> nodeIndex = new HashMap();
        final Map<ITimedAutomata.Predicate<C>, Integer> transIndex = new HashMap();

        Compiler() {
        }

        int computeStates() {
            int nb = TimedAutomata.this._stateMap.size();
            this.newNodes = new HashMap(nb);
            for (ITimedAutomata.State node : TimedAutomata.this._transitions.keySet()) {
                List<Next> n = this.nextStates(node);
                nb += Math.max(n.size() - 2, 0);
                this.newNodes.put(node, n);
            }
            return nb;
        }

        private ITimedAutomata<C> compile() {
            int nb = this.computeStates();
            this.allocateTables(nb);
            for (Map.Entry e : this.newNodes.entrySet()) {
                List<Next> lst = e.getValue();
                int size = lst.size() - 1;
                int node = TimedAutomata.this.getIndex(e.getKey(), this.nodeIndex);
                this.noTimeout(node);
                Next next = null;
                for (int i = 0; i < size; ++i) {
                    next = lst.get(i);
                    this.addTransitions(node, next);
                    if (i >= size - 1) continue;
                    ITimedAutomata.State state = e.getKey();
                    node = this.addTimeout(node, this.newState(state, "_" + next.deadline + "_" + i), next.deadline);
                }
                Next n = lst.get(size);
                if (n.deadline == 0) {
                    if (n.size() <= 0) continue;
                    if (next == null) {
                        System.err.println("States '" + e.getKey() + "' has only a timeout state !");
                    }
                    this.addTimeout(node, n.states.get(0), next == null ? 0 : next.deadline);
                    continue;
                }
                for (int i = 0; i < n.size(); ++i) {
                    this.addTransitions(node, n);
                }
            }
            return new CompiledTimedAutomata(TimedAutomata.this.mapToStates(this.nodeIndex), TimedAutomata.this.mapToPredicates(this.transIndex), this.nodeIndex.get(TimedAutomata.this._initial), this.transitionPredicates, this.timeouts, this.transitionTarget, this.timeoutTargets);
        }

        private ITimedAutomata.State<C> newState(final ITimedAutomata.State<C> state, final String suffix) {
            return new ITimedAutomata.State<C>(){

                @Override
                public String getName() {
                    return state.getName() + suffix;
                }

                @Override
                public List<ITimedAutomata.Action<C>> getActions() {
                    return state.getActions();
                }

                @Override
                public int getModifier() {
                    return state.getModifier();
                }

                @Override
                public void preAction(C context, ITimedAutomata.Executor<C> executor, String key) {
                    state.preAction(context, executor, key);
                }

                @Override
                public void eachAction(C context, ITimedAutomata.Executor<C> executor, String key) {
                    state.eachAction(context, executor, key);
                }

                @Override
                public void postAction(C context, ITimedAutomata.Executor<C> executor, String key) {
                    state.postAction(context, executor, key);
                }

                @Override
                public List<ITimedAutomata<C>> getSpawnableAutomatas() {
                    return state.getSpawnableAutomatas();
                }
            };
        }

        private void allocateTables(int size) {
            this.timeouts = new int[size];
            this.timeoutTargets = new int[size];
            this.transitionPredicates = new int[size][];
            this.transitionTarget = new int[size][];
        }

        private List<Next> nextStates(ITimedAutomata.State<C> state) {
            int m;
            ArrayList<Transition> nexts = new ArrayList<Transition>((Collection)TimedAutomata.this._transitions.get(state));
            ArrayList<Next> result = new ArrayList<Next>();
            int offset = 0;
            while ((m = this.nextDeadLine(nexts, offset)) != Integer.MAX_VALUE) {
                result.add(this.selectNextState(m - offset, m, nexts));
                offset = m;
            }
            switch (nexts.size()) {
                case 0: {
                    throw new RuntimeException("Automata has no default transition for node: " + state);
                }
                case 1: {
                    Transition target = (Transition)nexts.get(0);
                    Next timeout = new Next(target.timeout);
                    timeout.add(target.state, target.predicate);
                    result.add(timeout);
                    break;
                }
                default: {
                    Next infinites = new Next(-1);
                    for (Transition t : nexts) {
                        if (t.timeout != -1) {
                            throw new RuntimeException("Cannot mix timeout alternative and infinite guards, neither having more than a single timeout alternative ('" + state + "': " + nexts + ")");
                        }
                        infinites.add(t.state, t.predicate);
                    }
                    result.add(infinites);
                    break;
                }
            }
            return result;
        }

        Next selectNextState(int deadline, int elapsed, List<Transition> nexts) {
            Next next = new Next(deadline);
            Iterator<Transition> it = nexts.iterator();
            while (it.hasNext()) {
                Transition t = it.next();
                if (t.timeout == 0) continue;
                next.add(t.state, t.predicate);
                if (t.timeout != elapsed) continue;
                it.remove();
            }
            return next;
        }

        private int nextDeadLine(List<Transition> targets, int min) {
            int m = Integer.MAX_VALUE;
            for (Transition t : targets) {
                if (t.timeout == Integer.MAX_VALUE) {
                    throw new RuntimeException("2147483647 is a reserved timeout value");
                }
                if (t.timeout <= min) continue;
                m = Math.min(m, t.timeout);
            }
            return m;
        }

        private void noTimeout(int state) {
            this.timeouts[state] = -1;
            this.timeoutTargets[state] = -1;
        }

        private int addTimeout(int state, ITimedAutomata.State<C> nextState, int deadline) {
            this.timeouts[state] = deadline;
            this.timeoutTargets[state] = TimedAutomata.this.getIndex(nextState, this.nodeIndex);
            return this.timeoutTargets[state];
        }

        private void addTransitions(int node, Next next) {
            int ln = next.size();
            int[] pred = new int[ln];
            int[] target = new int[ln];
            this.transitionPredicates[node] = pred;
            this.transitionTarget[node] = target;
            for (int j = 0; j < ln; ++j) {
                pred[j] = TimedAutomata.this.getIndex(next.trans.get(j), this.transIndex);
                target[j] = TimedAutomata.this.getIndex(next.states.get(j), this.nodeIndex);
            }
        }
    }
}

