/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import fr.labri.AutoQualifiedClassLoader;
import fr.labri.tima.ITimedAutomata;
import fr.labri.tima.TimedAutomata;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderXSDFactory;

public class TimedAutomataFactory<C> {
    public static final String AUTOMATA_TAG = "timedautomata";
    public static final String AUTOMATA_NAME_TAG = "name";
    public static final String STATE_TAG = "state";
    public static final String TRANSITION_TAG = "path";
    public static final String TIMEOUT_TAG = "timeout";
    public static final String STATE_URGENT_TAG = "urgent";
    public static final String STATE_NAME_TAG = "name";
    public static final String STATE_INITIAL_TAG = "initial";
    public static final String STATE_TERMINAL_TAG = "terminal";
    public static final String ACTION_TAG = "action";
    public static final String ACTION_NAME_TAG = "type";
    public static final String ACTION_ATTR_TAG = "attr";
    public static final String SPAWN_TAG = "spawn";
    public static final String SPAWN_NAME_TAG = "name";
    public static final String SPAWN_ACTION_TAG = "type";
    public static final String SPAWN_ATTR_TAG = "attr";
    private static final String TERMINATE_TAG = "terminate";
    public static final String TRANSITION_TARGET_TAG = "to";
    public static final String TRANSITION_PREDICATE_TAG = "guard";
    public static final String TRANSITION_TIMEOUT_TAG = "timeout";
    public static final String TRANSITION_ATTR_TAG = "attr";
    public static final String XMLNS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_LOCATION = "http://www.labri.fr/~fmoranda/xsd/ta.xsd";
    final ITimedAutomata.NodeFactory<C> _factory;
    final Map<String, ITimedAutomata.Action<C>> _actionMap = new HashMap<String, ITimedAutomata.Action<C>>();
    final Map<String, ITimedAutomata.Predicate<C>> _predicateMap = new HashMap<String, ITimedAutomata.Predicate<C>>();

    public TimedAutomataFactory(ITimedAutomata.NodeFactory<C> factory) {
        this._factory = factory;
    }

    public final Document parseXML(InputStream stream, boolean validate) throws JDOMException, IOException {
        SAXBuilder sxb = new SAXBuilder((XMLReaderJDOMFactory)(validate ? new XMLReaderXSDFactory(new URL[]{TimedAutomata.class.getResource("ta.xsd")}) : null));
        Document document = sxb.build(stream);
        return document;
    }

    public final TimedAutomata<C> loadXML(InputStream stream) throws JDOMException, IOException {
        return this.loadXML(this.parseXML(stream, false));
    }

    public final TimedAutomata<C> loadXML(InputStream stream, boolean validate) throws JDOMException, IOException {
        return this.loadXML(this.parseXML(stream, validate));
    }

    public final TimedAutomata<C> loadXML(Document root) throws JDOMException, IOException {
        HashMap<String, Element> autosMap = new HashMap<String, Element>();
        HashMap<Element, TimedAutomata<C>> autos = new HashMap<Element, TimedAutomata<C>>();
        this.resolveAutomataName(root.getRootElement(), autosMap, autos);
        for (Element auto : autosMap.values()) {
            this.loadAutomata(auto, autosMap, autos);
        }
        return (TimedAutomata)autos.get(root.getRootElement());
    }

    private final void resolveAutomataName(Element auto, Map<String, Element> autosMap, Map<Element, TimedAutomata<C>> autos) {
        String name = auto.getAttributeValue("name");
        if (name == null) {
            throw new RuntimeException("Automata has no name: " + auto.toString());
        }
        if (autos.containsKey(name)) {
            throw new RuntimeException("There is more than one automata with the name: " + name);
        }
        autosMap.put(name, auto);
        autos.put(auto, new TimedAutomata());
        for (Element sub : auto.getChildren(AUTOMATA_TAG)) {
            this.resolveAutomataName(sub, autosMap, autos);
        }
    }

    public final ITimedAutomata<C> loadAutomata(Element auto, Map<String, Element> autosMap, Map<Element, TimedAutomata<C>> autos) throws JDOMException, IOException {
        HashMap<String, Element> stateMap = new HashMap<String, Element>();
        HashMap<Element, Element> spawnMap = new HashMap<Element, Element>();
        this.resolveStates(auto, autosMap, stateMap, spawnMap);
        HashMap<Element, Element> transMap = new HashMap<Element, Element>();
        this.resolveTransitions(auto, stateMap, transMap);
        TimedAutomata<C> cAuto = autos.get(auto);
        HashMap<Element, ITimedAutomata.State<C>> states = new HashMap<Element, ITimedAutomata.State<C>>();
        this.buildStates(cAuto, stateMap, states, spawnMap, autos);
        this.buildTransitions(cAuto, states, transMap);
        return cAuto;
    }

    private void buildTransitions(TimedAutomata<C> auto, Map<Element, ITimedAutomata.State<C>> stateMap, Map<Element, Element> transMap) {
        for (Map.Entry<Element, ITimedAutomata.State<C>> entry : stateMap.entrySet()) {
            Element srcElt = entry.getKey();
            ITimedAutomata.State<C> src = entry.getValue();
            for (Element trans : srcElt.getChildren(TRANSITION_TAG)) {
                ITimedAutomata.State<C> dest = stateMap.get(transMap.get(trans));
                String pred = trans.getAttributeValue(TRANSITION_PREDICATE_TAG);
                String timeoutval = trans.getAttributeValue("timeout");
                String attr = trans.getAttributeValue("attr");
                int timeout = timeoutval == null ? -1 : Integer.parseInt(timeoutval);
                auto.addTransition(src, timeout, this.getPredicate(pred, attr), dest);
            }
            Element timeout = srcElt.getChild("timeout");
            if (timeout == null) continue;
            ITimedAutomata.State<C> dest = stateMap.get(transMap.get(timeout));
            auto.addDefaultTransition(src, dest);
        }
    }

    private void buildStates(TimedAutomata<C> auto, Map<String, Element> stateMap, Map<Element, ITimedAutomata.State<C>> states, Map<Element, Element> spawnMap, Map<Element, TimedAutomata<C>> autos) {
        for (Map.Entry<String, Element> entry : stateMap.entrySet()) {
            boolean isTerm = false;
            boolean isSpawn = false;
            Element state = entry.getValue();
            ArrayList<Spawn> spawns = new ArrayList<Spawn>();
            ArrayList<ITimedAutomata.Action<C>> acts = new ArrayList<ITimedAutomata.Action<C>>();
            for (Element act : state.getChildren()) {
                if (isTerm) {
                    throw new RuntimeException("Unreachable code, actions after terminate in " + entry.getKey());
                }
                String aName = act.getName();
                if (ACTION_TAG.equalsIgnoreCase(aName)) {
                    ITimedAutomata.Action<C> a = this.getAction(act.getAttributeValue("type"), act.getAttributeValue("attr"));
                    if (a == null) {
                        throw new RuntimeException("Unable to create action : " + act.getAttributeValue("type") + "(" + act.getAttributeValue("attr") + ")");
                    }
                    acts.add(a);
                    continue;
                }
                if (SPAWN_TAG.equalsIgnoreCase(aName)) {
                    spawns.add(this.newSpawnAction(act, spawnMap, autos));
                    isSpawn = true;
                    continue;
                }
                if (TERMINATE_TAG.equalsIgnoreCase(aName)) {
                    isTerm = true;
                    continue;
                }
                if (TRANSITION_TAG.equalsIgnoreCase(aName) || "timeout".equalsIgnoreCase(aName)) continue;
                throw new RuntimeException("Unknwown tag: " + aName);
            }
            String dfltAct = state.getAttributeValue(ACTION_TAG);
            if (dfltAct != null) {
                ITimedAutomata.Action<C> a = this.getAction(dfltAct, state.getAttributeValue("attr"));
                if (a == null) {
                    throw new RuntimeException("Unable to create default action : " + state.getAttributeValue("type") + "(" + state.getAttributeValue("attr") + ")");
                }
                acts.add(a);
            } else if (state.getAttributeValue("attr") != null) {
                throw new RuntimeException("Attribue without action in state: " + entry.getKey());
            }
            if ("true".equalsIgnoreCase(state.getAttributeValue(STATE_TERMINAL_TAG))) {
                if (isTerm) {
                    throw new RuntimeException("More than one terminate in " + entry.getKey());
                }
                isTerm = true;
            }
            boolean isInitial = "true".equalsIgnoreCase(state.getAttributeValue(STATE_INITIAL_TAG));
            int modifiers = ("true".equalsIgnoreCase(state.getAttributeValue(STATE_URGENT_TAG)) ? 2 : 0) | (isInitial ? 1 : 0) | (isSpawn ? 4 : 0) | (isTerm ? 8 : 0);
            ITimedAutomata.State<C> st = this.newState(entry.getKey(), acts, spawns, modifiers);
            states.put(state, st);
            if (!isInitial) continue;
            auto.setInitial(st);
        }
    }

    ITimedAutomata.State<C> newState(final String name, final ArrayList<ITimedAutomata.Action<C>> actions, final ArrayList<Spawn> automatas, final int modifiers) {
        return new ITimedAutomata.State<C>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public List<ITimedAutomata.Action<C>> getActions() {
                return actions;
            }

            @Override
            public List<ITimedAutomata<C>> getSpawnableAutomatas() {
                return null;
            }

            @Override
            public int getModifier() {
                return modifiers;
            }

            @Override
            public void preAction(C context, ITimedAutomata.Executor<C> executor, String key) {
                if ((modifiers & 4) > 0) {
                    for (Spawn spawn : automatas) {
                        spawn.start(executor, context, key);
                    }
                }
                for (ITimedAutomata.Action action : this.getActions()) {
                    action.preAction(context, key);
                }
            }

            @Override
            public void eachAction(C context, ITimedAutomata.Executor<C> executor, String key) {
                for (ITimedAutomata.Action action : this.getActions()) {
                    action.eachAction(context, key);
                }
            }

            @Override
            public void postAction(C context, ITimedAutomata.Executor<C> executor, String key) {
                for (ITimedAutomata.Action action : this.getActions()) {
                    action.postAction(context, key);
                }
            }
        };
    }

    private Spawn newSpawnAction(Element source, Map<Element, Element> spawnMap, Map<Element, TimedAutomata<C>> autos) {
        String spawnerName = source.getAttributeValue("type");
        String spawnerAttr = source.getAttributeValue("attr");
        ITimedAutomata.Spawner<C> spawner = spawnerName == null ? null : this._factory.newSpawner(spawnerName, spawnerAttr);
        TimedAutomata<C> target = autos.get(spawnMap.get(source));
        return new Spawn(target, spawner);
    }

    private void resolveTransitions(Element root, Map<String, Element> stateMap, Map<Element, Element> transMap) {
        for (Element state : root.getChildren(STATE_TAG)) {
            Element target;
            boolean hasTimeout = false;
            for (Element trans : state.getChildren("timeout")) {
                target = stateMap.get(trans.getAttributeValue(TRANSITION_TARGET_TAG));
                if (hasTimeout) {
                    throw new RuntimeException("State '" + target + "' has more than one timeout");
                }
                if (target == null) {
                    throw new RuntimeException("Timeout target does not exists in '" + root.getAttributeValue("name") + "/" + state + "': " + trans.getAttributeValue(TRANSITION_TARGET_TAG));
                }
                transMap.put(trans, target);
                hasTimeout = true;
            }
            for (Element trans : state.getChildren(TRANSITION_TAG)) {
                String timeoutval;
                target = stateMap.get(trans.getAttributeValue(TRANSITION_TARGET_TAG));
                if (hasTimeout && (timeoutval = trans.getAttributeValue("timeout")) != null && Integer.parseInt(timeoutval) == -1) {
                    throw new RuntimeException("Cannot mix timeout and infinite guars in: " + state);
                }
                if (target == null) {
                    throw new RuntimeException("Target does not exists in '" + root.getAttributeValue("name") + "': " + trans.getAttributeValue(TRANSITION_TARGET_TAG));
                }
                transMap.put(trans, target);
            }
        }
    }

    private Element resolveStates(Element root, Map<String, Element> autos, Map<String, Element> stateMap, Map<Element, Element> spawnMap) throws JDOMException {
        Element initial = null;
        for (Element state : root.getChildren(STATE_TAG)) {
            String name = state.getAttributeValue("name");
            if (stateMap.containsKey(name)) {
                throw new JDOMException("Node name is not unique: " + name);
            }
            stateMap.put(name, state);
            if ("true".equalsIgnoreCase(state.getAttributeValue(STATE_INITIAL_TAG))) {
                if (initial != null) {
                    throw new RuntimeException("More than one initial state in " + root.getAttributeValue("name") + ": '" + initial + "', '" + state + "'");
                }
                initial = state;
            }
            for (Element spawn : root.getChildren(SPAWN_TAG)) {
                String tName = spawn.getAttributeValue("name");
                if (tName == null) {
                    throw new RuntimeException("Spawning unamed automata in " + root.getAttributeValue("name") + "/" + name);
                }
                Element target = autos.get(tName);
                if (target == null) {
                    throw new RuntimeException("Spawning unknwon automata '" + tName + "' in " + root.getAttributeValue("name") + "/" + name);
                }
                spawnMap.put(spawn, target);
            }
        }
        if (initial == null) {
            throw new RuntimeException(root.getAttributeValue("name") + " automata has no initial state");
        }
        return initial;
    }

    public ITimedAutomata.Action<C> getAction(String type, String attr) {
        String name = type + (attr == null ? "" : ":" + attr);
        if (this._actionMap.containsKey(name)) {
            return this._actionMap.get(name);
        }
        ITimedAutomata.Action<C> act = this._factory.newAction(type, attr);
        this._actionMap.put(name, act);
        return act;
    }

    public static final boolean hasModifier(int modifiers, int modifier) {
        return (modifiers & modifier) > 0;
    }

    public ITimedAutomata.Predicate<C> getPredicate(String type, String attr) {
        String name = type + (attr == null ? "" : ":" + attr);
        if (this._predicateMap.containsKey(name)) {
            return this._predicateMap.get(name);
        }
        ITimedAutomata.Predicate<C> t = this._factory.newPredicate(name, attr);
        this._predicateMap.put(name, t);
        return t;
    }

    public int getModifierFromNode(Element state) {
        String name = state.getAttributeValue("name");
        return ("true".equalsIgnoreCase(state.getAttributeValue(STATE_URGENT_TAG)) ? 2 : 0) | ("true".equalsIgnoreCase(state.getAttributeValue(STATE_INITIAL_TAG)) ? 1 : 0) | ("stop".equalsIgnoreCase(name) || TERMINATE_TAG.equalsIgnoreCase(name) ? 8 : 0) | (state.getChild(SPAWN_TAG) != null ? 4 : 0);
    }

    public static <C> ITimedAutomata.NodeFactory<C> getReflectNodeBuilder(Class<C> dummy) {
        return TimedAutomataFactory.getReflectNodeBuilder(TimedAutomata.class.getClassLoader(), dummy);
    }

    public static <C> ITimedAutomata.NodeFactory<C> getReflectNodeBuilder(String searchPrefix, Class<C> dummy) {
        return TimedAutomataFactory.getReflectNodeBuilder(new AutoQualifiedClassLoader(searchPrefix), dummy);
    }

    public static <C> ITimedAutomata.NodeFactory<C> getReflectNodeBuilder(final ClassLoader loader, Class<C> dummy) {
        return new ITimedAutomata.NodeFactory<C>(){

            @Override
            public ITimedAutomata.Action<C> newAction(String type, String attr) {
                return (ITimedAutomata.Action)this.newInstance(type, attr);
            }

            @Override
            public ITimedAutomata.Predicate<C> newPredicate(String type, String attr) {
                return (ITimedAutomata.Predicate)this.newInstance(type, attr);
            }

            @Override
            public ITimedAutomata.Spawner<C> newSpawner(String type, String attr) {
                return (ITimedAutomata.Spawner)this.newInstance(type, attr);
            }

            public <T> T newInstance(String type, String attr) {
                try {
                    Class<?> clz = loader.loadClass(type);
                    T state = null;
                    if (type == null) {
                        return null;
                    }
                    try {
                        state = (T)clz.getConstructor(String.class).newInstance(attr);
                    }
                    catch (NoSuchMethodException e) {
                        state = (T)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    return state;
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    return null;
                }
            }
        };
    }

    class Spawn {
        private ITimedAutomata<C> _auto;
        private ITimedAutomata.Spawner<C> _spawner;

        Spawn(ITimedAutomata<C> auto, ITimedAutomata.Spawner<C> spawner) {
            this._auto = auto;
        }

        public void start(ITimedAutomata.Executor<C> executor, C context, String parentKey) {
            executor.start(this._auto, this._spawner == null ? null : this._spawner.getSpawnerKey(context, parentKey));
        }

        public ITimedAutomata<C> getTargetAutomata() {
            return this._auto;
        }
    }
}

