/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import fr.labri.Utils;
import fr.labri.tima.DotRenderer;
import fr.labri.tima.ITimedAutomata;

public class CompiledTimedAutomata<C>
implements ITimedAutomata<C> {
    final ITimedAutomata.State<C>[] _states;
    final ITimedAutomata.Predicate<C>[] _predicates;
    int _initial;
    final int[][] _transitionsPredicates;
    final int[][] _transitionsTarget;
    final int[] _timeouts;
    final int[] _timeoutsTarget;

    public CompiledTimedAutomata(ITimedAutomata.State<C>[] states, ITimedAutomata.Predicate<C>[] predicates, int initial, int[][] transitionsPredicates, int[] timeouts, int[][] transitionsTarget, int[] timeoutsTarget) {
        this._states = states;
        this._predicates = predicates;
        this._transitionsPredicates = transitionsPredicates;
        this._timeouts = timeouts;
        this._transitionsTarget = transitionsTarget;
        this._timeoutsTarget = timeoutsTarget;
        this._initial = initial;
        int l = states.length;
        if (l != transitionsPredicates.length || l != timeouts.length || l != transitionsTarget.length || l != timeoutsTarget.length) {
            throw new RuntimeException("Automata is not well formed !");
        }
    }

    public CompiledTimedAutomata(ITimedAutomata.State<C>[] states, ITimedAutomata.Predicate<C>[] predicates, ITimedAutomata.Action<C> initial, int[][] transitionsPredicates, int[] timeouts, int[][] transitionsTarget, int[] timeoutsTarget) {
        this(states, predicates, Utils.indexOf(initial, states), transitionsPredicates, timeouts, transitionsTarget, timeoutsTarget);
    }

    @Override
    public ITimedAutomata.Cursor<C> start(final ITimedAutomata.ContextProvider<C> context, final String key) {
        return new ITimedAutomata.Cursor<C>(){
            int _current;
            int _currentTimeout;

            @Override
            public final boolean next(ITimedAutomata.Executor<C> executor) {
                boolean urgent = false;
                boolean terminal = false;
                do {
                    int current;
                    int target = current = this._current;
                    Object ctx = context.getContext();
                    if (this._currentTimeout > 0 && this._currentTimeout-- == 0) {
                        target = CompiledTimedAutomata.this._timeoutsTarget[this._current];
                    } else {
                        int[] trans = CompiledTimedAutomata.this._transitionsPredicates[this._current];
                        int len = trans.length;
                        int i = 0;
                        while (i < len) {
                            if (CompiledTimedAutomata.this._predicates[trans[i]].isValid(ctx, key)) {
                                target = CompiledTimedAutomata.this._transitionsTarget[this._current][i];
                                break;
                            }
                            ++i;
                        }
                    }
                    if (target == current) {
                        CompiledTimedAutomata.this._states[target].eachAction(ctx, executor, key);
                        continue;
                    }
                    ITimedAutomata.State state = this.setState(target, executor, ctx);
                    urgent = (state.getModifier() & 2) > 0;
                    boolean bl = terminal = (state.getModifier() & 8) > 0;
                } while (urgent);
                return terminal;
            }

            private final ITimedAutomata.State<C> setState(int target, ITimedAutomata.Executor<C> executor, C context2) {
                CompiledTimedAutomata.this._states[this._current].postAction(context2, executor, key);
                this._current = target;
                this._currentTimeout = CompiledTimedAutomata.this._timeouts[target];
                ITimedAutomata.State newState = CompiledTimedAutomata.this._states[target];
                newState.preAction(context2, executor, key);
                return newState;
            }

            @Override
            public ITimedAutomata<C> getAutomata() {
                return CompiledTimedAutomata.this;
            }

            @Override
            public String getKey() {
                return key;
            }
        };
    }

    @Override
    public final ITimedAutomata.State<C> getInitialState() {
        return this._states[this._initial];
    }

    @Override
    public final void setInitialState(ITimedAutomata.State<C> initial) {
        this._initial = Utils.indexOf(initial, this._states);
    }

    @Override
    public final ITimedAutomata.State<C>[] getStates() {
        return this._states;
    }

    @Override
    public ITimedAutomata.State<C>[] getFollowers(ITimedAutomata.State<C> src) {
        int id = Utils.indexOf(src, this._states);
        int[] line = this._transitionsTarget[id];
        int l = line.length;
        int size = (this._timeoutsTarget[id] == -1 ? 0 : 1) + l;
        ITimedAutomata.State[] states = new ITimedAutomata.State[size];
        int i = 0;
        while (i < l) {
            int t = line[i];
            states[i] = this._states[t];
            ++i;
        }
        if (l != size) {
            states[l] = this._states[this._timeoutsTarget[id]];
        }
        return states;
    }

    @Override
    public int getTimeout(ITimedAutomata.State<C> src, ITimedAutomata.State<C> dst) {
        int idDst;
        int idSrc = Utils.indexOf(src, this._states);
        if (this._timeoutsTarget[idSrc] == (idDst = Utils.indexOf(src, this._states))) {
            return 0;
        }
        return this._timeoutsTarget[idSrc];
    }

    @Override
    public ITimedAutomata.Predicate<C> getPredicate(ITimedAutomata.State<C> src, ITimedAutomata.State<C> dst) {
        int idSrc = Utils.indexOf(src, this._states);
        int idDst = Utils.indexOf(src, this._states);
        int[] line = this._transitionsTarget[idSrc];
        int i = 0;
        while (i < line.length) {
            if (line[i] == idDst) {
                return this._predicates[this._transitionsPredicates[idSrc][i]];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return DotRenderer.toDot(this);
    }

    @Override
    public ITimedAutomata<C> compile() {
        return this;
    }
}

