/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import java.util.Collection;
import java.util.List;

public interface ITimedAutomata<C> {
    public static final int INITIAL = 1;
    public static final int URGENT = 2;
    public static final int SPAWN = 4;
    public static final int TERMINATE = 8;

    public State<C> getInitialState();

    public void setInitialState(State<C> var1);

    public State<C>[] getStates();

    public State<C>[] getFollowers(State<C> var1);

    public int getTimeout(State<C> var1, State<C> var2);

    public Predicate<C> getPredicate(State<C> var1, State<C> var2);

    public ITimedAutomata<C> compile();

    public Cursor<C> start(ContextProvider<C> var1, String var2);

    public static interface Action<C> {
        public void preAction(C var1, String var2);

        public void eachAction(C var1, String var2);

        public void postAction(C var1, String var2);

        public String getType();
    }

    public static class ActionAdapter<C>
    implements Action<C> {
        @Override
        public String getType() {
            return this.getClass().getCanonicalName();
        }

        @Override
        public void preAction(C context, String key) {
        }

        @Override
        public void eachAction(C context, String key) {
        }

        @Override
        public void postAction(C context, String key) {
        }

        public String toString() {
            return this.getType();
        }
    }

    public static interface ContextProvider<C> {
        public C getContext();
    }

    public static interface Cursor<C> {
        public boolean next(Executor<C> var1);

        public String getKey();

        public ITimedAutomata<C> getAutomata();
    }

    public static interface Executor<C> {
        public Executor<C> start(ITimedAutomata<C> var1, String var2);

        public boolean next();

        public Collection<Cursor<C>> getCursors();
    }

    public static interface NodeFactory<C> {
        public Predicate<C> newPredicate(String var1, String var2);

        public Action<C> newAction(String var1, String var2);

        public Spawner<C> newSpawner(String var1, String var2);
    }

    public static interface Predicate<C> {
        public boolean isValid(C var1, String var2);

        public String getType();
    }

    public static class PredicateAdapter<C>
    implements Predicate<C> {
        @Override
        public boolean isValid(C context, String key) {
            return false;
        }

        @Override
        public String getType() {
            return this.getClass().getCanonicalName();
        }

        public String toString() {
            return this.getType();
        }
    }

    public static class SpawnAdapter<C>
    implements Spawner<C> {
        @Override
        public String getType() {
            return this.getClass().getCanonicalName();
        }

        @Override
        public String getSpawnerKey(C context, String parentKey) {
            return null;
        }

        public String toString() {
            return this.getType();
        }
    }

    public static interface Spawner<C> {
        public String getType();

        public String getSpawnerKey(C var1, String var2);
    }

    public static interface State<C> {
        public String getName();

        public List<Action<C>> getActions();

        public int getModifier();

        public void preAction(C var1, Executor<C> var2, String var3);

        public void eachAction(C var1, Executor<C> var2, String var3);

        public void postAction(C var1, Executor<C> var2, String var3);

        public List<ITimedAutomata<C>> getSpawnableAutomatas();
    }
}

