/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import fr.labri.tima.ITimedAutomata;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JFrame;

public class AutomataViewer {
    private static final int GAP = 50;

    public static JFrame viewAsFrame(ITimedAutomata<?> automata) {
        JFrame frame = new JFrame("Simple Graph View");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)AutomataViewer.createPanel(automata));
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static <C> VisualizationViewer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createPanel(ITimedAutomata.Executor<C> executor) {
        return AutomataViewer.createPanel(executor, new Dimension(300, 300));
    }

    public static <C> VisualizationViewer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createPanel(ITimedAutomata<C> auto) {
        return AutomataViewer.createPanel(auto, new Dimension(300, 300));
    }

    public static <C> VisualizationViewer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createPanel(Collection<? extends ITimedAutomata<C>> autos) {
        return AutomataViewer.createPanel(autos, new Dimension(300, 300));
    }

    public static <C> VisualizationViewer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createPanel(ITimedAutomata<C> auto, Dimension dimension) {
        return AutomataViewer.createPanel(dimension, AutomataViewer.createGraph(auto));
    }

    public static <C> VisualizationViewer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createPanel(ITimedAutomata.Executor<C> executor, Dimension dimension) {
        ArrayList<ITimedAutomata<C>> lst = new ArrayList<ITimedAutomata<C>>();
        for (ITimedAutomata.Cursor<C> cursor : executor.getCursors()) {
            lst.add(cursor.getAutomata());
        }
        return AutomataViewer.createPanel(dimension, AutomataViewer.createGraph(lst));
    }

    public static <C> VisualizationViewer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createPanel(Collection<? extends ITimedAutomata<C>> autos, Dimension dimension) {
        return AutomataViewer.createPanel(dimension, AutomataViewer.createGraph(autos));
    }

    public static <C> VisualizationViewer<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createPanel(Dimension dimension, DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> g) {
        FRLayout layout = new FRLayout(g, dimension);
        VisualizationViewer vv = new VisualizationViewer((Layout)layout);
        vv.setAutoscrolls(true);
        vv.setPreferredSize(new Dimension(dimension.width + 50, dimension.height + 50));
        return vv;
    }

    public static <C> DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createGraph(Collection<? extends ITimedAutomata<C>> autos) {
        DirectedSparseGraph graph = new DirectedSparseGraph();
        for (ITimedAutomata<C> auto : autos) {
            AutomataViewer.createGraph(auto, graph);
        }
        return graph;
    }

    public static <C> DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createGraph(ITimedAutomata<C>[] autos) {
        return AutomataViewer.createGraph(Arrays.asList(autos));
    }

    public static <C> DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createGraph(ITimedAutomata<C> auto) {
        DirectedSparseGraph graph = new DirectedSparseGraph();
        AutomataViewer.createGraph(auto, graph);
        return graph;
    }

    private static <C> DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> createGraph(ITimedAutomata<C> auto, DirectedGraph<ITimedAutomata.State<C>, ITimedAutomata.Predicate<C>> sgv) {
        for (ITimedAutomata.State<C> state : auto.getStates()) {
            sgv.addVertex(state);
        }
        for (ITimedAutomata.State<C> state : auto.getStates()) {
            for (ITimedAutomata.State<C> dst : auto.getFollowers(state)) {
                final ITimedAutomata.Predicate<C> pred = auto.getPredicate(state, dst);
                int timeout = auto.getTimeout(state, dst);
                if (timeout != 0) {
                    sgv.addEdge((Object)new ITimedAutomata.Predicate<C>(){

                        @Override
                        public boolean isValid(C context, String key) {
                            return pred.isValid(context, key);
                        }

                        @Override
                        public String getType() {
                            return pred.getType();
                        }
                    }, state, dst);
                    continue;
                }
                sgv.addEdge(new DefaultTransition<C>(pred), state, dst);
            }
        }
        return sgv;
    }

    private static class DefaultTransition<C>
    implements ITimedAutomata.Predicate<C> {
        final ITimedAutomata.Predicate<C> _pred;

        public DefaultTransition(ITimedAutomata.Predicate<C> pred) {
            this._pred = pred;
        }

        @Override
        public boolean isValid(C context, String key) {
            return this._pred.isValid(context, key);
        }

        @Override
        public String getType() {
            return this._pred.getType();
        }
    }
}

