/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import fr.labri.Utils;
import fr.labri.tima.ITimedAutomata;
import java.util.Collection;

public class DotRenderer {
    public static final String INFINITY_SYMBOL = "+oo";

    public static <C> String toDot(ITimedAutomata<C> auto) {
        return DotRenderer.toDot(auto, "G");
    }

    public static <C> String toDot(ITimedAutomata<C> auto, String name) {
        StringBuilder b = new StringBuilder("digraph ").append(name).append(" {\nedge [splines=ortho];\n");
        b.append(DotRenderer.drawGraph(auto, ""));
        return b.append("};").toString();
    }

    public static <C> String toDot(ITimedAutomata.Executor<C> exec, String name) {
        StringBuilder b = new StringBuilder("digraph ").append(name).append(" {\nedge [splines=ortho];\n");
        int i = 0;
        for (ITimedAutomata.Cursor<C> cursor : exec.getCursors()) {
            b.append("subgraph cluster_").append(Integer.toString(i)).append(" {\n");
            b.append(DotRenderer.drawGraph(cursor.getAutomata(), "_" + i++));
            b.append("}");
        }
        return b.append("};").toString();
    }

    public static <C> String toDot(Collection<? extends ITimedAutomata<C>> autos, String name) {
        StringBuilder b = new StringBuilder("digraph ").append(name).append(" {\nedge [splines=ortho];\n");
        int i = 0;
        for (ITimedAutomata<C> auto : autos) {
            b.append("subgraph cluster_").append(Integer.toString(i)).append(" {\n");
            b.append(DotRenderer.drawGraph(auto, "_" + i++));
            b.append("}");
        }
        return b.append("};").toString();
    }

    public static <C> String drawGraph(ITimedAutomata<C> auto, String offset) {
        ITimedAutomata.State<C>[] states;
        StringBuilder b = new StringBuilder();
        ITimedAutomata.State<C>[] stateArray = states = auto.getStates();
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            ITimedAutomata.State<C> state = stateArray[n2];
            b.append(DotRenderer.getNodeID(state, states, offset)).append(" [").append(DotRenderer.getStateDecoration(state)).append("];\n");
            ITimedAutomata.State<C>[] stateArray2 = auto.getFollowers(state);
            int n3 = stateArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ITimedAutomata.State<C> dst = stateArray2[n4];
                if (dst != null) {
                    b.append(DotRenderer.getNodeID(state, states, offset)).append(" -> ").append(DotRenderer.getNodeID(dst, states, offset)).append(" [").append(DotRenderer.getTransitionDecoration(auto, state, dst)).append("];\n");
                }
                ++n4;
            }
            ++n2;
        }
        return b.toString();
    }

    private static <C> String getTransitionDecoration(ITimedAutomata<C> auto, ITimedAutomata.State<C> src, ITimedAutomata.State<C> dst) {
        StringBuilder b = new StringBuilder();
        int timeout = auto.getTimeout(src, dst);
        ITimedAutomata.Predicate<C> pred = auto.getPredicate(src, dst);
        String sep = "";
        if (pred != null) {
            b.append("label=\"").append(pred.getType()).append("\"");
            sep = ", ";
        }
        if (timeout != 0) {
            b.append(sep).append("taillabel=\"").append(timeout == -1 ? INFINITY_SYMBOL : Integer.toString(timeout)).append("\"");
            sep = ", ";
        }
        if (timeout == 0) {
            b.append(sep).append("style=dashed");
        }
        return b.toString();
    }

    public static <C> String getNodeID(ITimedAutomata.State<C> state, ITimedAutomata.State<C>[] states, String offset) {
        return "node" + offset + Integer.toString(Utils.indexOf(state, states));
    }

    public static <C> String getStateDecoration(ITimedAutomata.State<C> state) {
        StringBuilder b = new StringBuilder();
        b.append("shape=\"record\", label=\"{").append(state.getName()).append("|{");
        String sep = "";
        for (ITimedAutomata.Action<C> a : state.getActions()) {
            b.append(sep).append(a.getType());
            sep = "|";
        }
        b.append("}}\"");
        int mod = state.getModifier();
        b.append(", style=\"filled");
        if ((mod & 1) > 0) {
            b.append(",diagonals");
        }
        if ((mod & 2) > 0) {
            b.append(",bold");
        }
        b.append("\"");
        if ((mod & 8) > 0) {
            b.append(", color=\"red\"");
        }
        if ((mod & 4) > 0) {
            b.append(", fillcolor=\"yellow\"");
        } else {
            b.append(", fillcolor=\"white\"");
        }
        return b.toString();
    }
}

