/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import fr.labri.AutoQualifiedClassLoader;
import fr.labri.DotViewer;
import fr.labri.tima.DotRenderer;
import fr.labri.tima.ITimedAutomata;
import fr.labri.tima.SimpleNodeFactory;
import fr.labri.tima.TimedAutomata;
import fr.labri.tima.TimedAutomataFactory;
import java.io.IOException;
import java.util.List;
import org.jdom2.JDOMException;

public class TimaTester {
    private final AutoQualifiedClassLoader _classLoader;
    private boolean _render;
    public static final boolean RENDER = Boolean.parseBoolean(System.getProperty("tima.test.render", "true"));
    public static final boolean COMPILED = Boolean.parseBoolean(System.getProperty("tima.test.compile", "false"));
    public static final boolean VERBOSE = Boolean.parseBoolean(System.getProperty("tima.test.verbose", "true"));

    public TimaTester(String namespace) {
        this(namespace, RENDER);
    }

    public TimaTester(String namespace, boolean render) {
        this._classLoader = new AutoQualifiedClassLoader(namespace);
        this._render = render;
    }

    void setRender(boolean render) {
        this._render = render;
    }

    <C> void test(String name, String namespace, Class<C> dummy) throws JDOMException, IOException {
        String fname = "/" + name.replaceAll("\\.", "/") + ".xml";
        List<TimedAutomata<C>> b = new TimedAutomataFactory<C>(this.getSimpleNodeBuilder(namespace, dummy)).loadXML(this.getClass().getResourceAsStream(fname));
        String dot = DotRenderer.toDot(b, name.substring(name.lastIndexOf(".") + 1));
        if (this._render) {
            DotViewer.view(dot);
        } else {
            System.out.println(dot);
        }
    }

    <C> ITimedAutomata.NodeFactory<C> getSimpleNodeBuilder(final String namespace, Class<C> dummy) {
        final ITimedAutomata.NodeFactory<C> factory = TimedAutomataFactory.getReflectNodeBuilder(new AutoQualifiedClassLoader(namespace, this._classLoader), dummy);
        return new SimpleNodeFactory<C>(){

            @Override
            public ITimedAutomata.Predicate<C> newPredicate(String type, String attr) {
                if (factory.newPredicate(type, attr) == null) {
                    this.error(type);
                } else {
                    this.ok(type);
                }
                return super.newPredicate(type, attr);
            }

            @Override
            public ITimedAutomata.Action<C> newAction(String type, String attr) {
                if (factory.newAction(type, attr) == null) {
                    this.error(type);
                } else {
                    this.ok(type);
                }
                return super.newAction(type, attr);
            }

            @Override
            public ITimedAutomata.Spawner<C> newSpawner(String type, String attr) {
                if (factory.newSpawner(type, attr) == null) {
                    this.error(type);
                } else {
                    this.ok(type);
                }
                return super.newSpawner(type, attr);
            }

            private void ok(String name) {
                if (VERBOSE) {
                    System.out.printf("Class '%s' loaded\n", name);
                }
            }

            private void error(String name) {
                System.err.printf("Class '%s' not found in '%s'\n", name, namespace);
            }
        };
    }
}

