/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.tima;

import fr.labri.tima.ITimedAutomata;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;

public class BasicExecutor<C>
implements ITimedAutomata.Executor<C> {
    List<ITimedAutomata.Cursor<C>> _cursors = new LinkedList<ITimedAutomata.Cursor<C>>();
    ITimedAutomata.ContextProvider<C> _context;
    TAViewer _viewer;

    public BasicExecutor(ITimedAutomata.ContextProvider<C> context) {
        this._context = context;
    }

    @Override
    public BasicExecutor<C> start(ITimedAutomata<C> auto, String key) {
        this._cursors.add(auto.start(this._context, key));
        if (this._viewer != null) {
            this._viewer.update();
        }
        return this;
    }

    @Override
    public boolean next() {
        Iterator<ITimedAutomata.Cursor<C>> it = this._cursors.iterator();
        while (it.hasNext()) {
            ITimedAutomata.Cursor<C> c = it.next();
            if (!c.next(this)) continue;
            it.remove();
            this._viewer.update();
        }
        return !this._cursors.isEmpty();
    }

    @Override
    public Collection<ITimedAutomata.Cursor<C>> getCursors() {
        return Collections.unmodifiableCollection(this._cursors);
    }

    public JList<String> getViewer() {
        this._viewer = new TAViewer();
        return new JList<String>(this._viewer);
    }

    class TAViewer
    extends AbstractListModel<String> {
        TAViewer() {
        }

        @Override
        public int getSize() {
            return BasicExecutor.this._cursors.size();
        }

        @Override
        public String getElementAt(int i) {
            return BasicExecutor.this._cursors.get(i).toString();
        }

        public void update() {
            this.fireContentsChanged(this, 0, BasicExecutor.this._cursors.size() - 1);
        }
    }
}

