/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.Version;
import org.arabidopsis.ahocorasick.OutputResult;
import org.arabidopsis.ahocorasick.OutputSizeCalculator;
import org.arabidopsis.ahocorasick.Queue;
import org.arabidopsis.ahocorasick.SearchResult;
import org.arabidopsis.ahocorasick.Searcher;
import org.arabidopsis.ahocorasick.State;
import org.arabidopsis.ahocorasick.StringOutputSizeCalculator;
import org.arabidopsis.ahocorasick.TokensInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AhoCorasick
implements Serializable {
    private static final long serialVersionUID = -4152244297395236698L;
    private State root = new State(0);
    private boolean prepared = false;
    private OutputSizeCalculator outputSizeCalculator = new StringOutputSizeCalculator();

    public AhoCorasick() {
    }

    public AhoCorasick(OutputSizeCalculator outputSizeCalculator) {
        this();
        if (outputSizeCalculator == null) {
            throw new IllegalStateException("The outputSizeCalculator attribute musn't be null");
        }
        this.outputSizeCalculator = outputSizeCalculator;
    }

    public void add(String keyword, Object output) {
        this.add(keyword.toCharArray(), output);
    }

    public void add(String keyword) {
        this.add(keyword.toCharArray());
    }

    public void add(char[] keyword) {
        this.add(keyword, (Object)new String(keyword));
    }

    public void add(char[] keyword, Object output) {
        if (this.prepared) {
            throw new IllegalStateException("can't add keywords after prepare() is called");
        }
        State lastState = this.root.extendAll(keyword);
        lastState.addOutput(output);
    }

    public void prepare() {
        this.prepareFailTransitions();
        this.prepared = true;
    }

    public Iterator<SearchResult> progressiveSearch(String inputText) {
        return this.progressiveSearch(inputText.toCharArray());
    }

    public Iterator<SearchResult> progressiveSearch(char[] chars) {
        return new Searcher(this, this.startSearch(chars));
    }

    public List<OutputResult> completeSearch(String inputText, boolean allowOverlapping, boolean onlyTokens) {
        return this.completeSearch(inputText.toCharArray(), allowOverlapping, onlyTokens);
    }

    public List<OutputResult> completeSearch(char[] chars, boolean allowOverlapping, boolean onlyTokens) {
        Searcher searcher = new Searcher(this, this.startSearch(chars));
        List<OutputResult> result = this.recollectOutputResults(searcher, chars, onlyTokens);
        this.sortOutputResults(result);
        if (!allowOverlapping) {
            this.removeOverlapping(result);
        }
        return result;
    }

    void removeOverlapping(List<OutputResult> outputResults) {
        int currentIndex = 0;
        while (currentIndex < outputResults.size() - 1) {
            OutputResult next;
            OutputResult current = outputResults.get(currentIndex);
            if (!current.isOverlapped(next = outputResults.get(currentIndex + 1))) {
                ++currentIndex;
                continue;
            }
            if (current.dominate(next)) {
                outputResults.remove(currentIndex + 1);
                continue;
            }
            outputResults.remove(currentIndex);
        }
    }

    private void prepareFailTransitions() {
        State state;
        char[] keys;
        Queue q = new Queue();
        for (char key : keys = this.root.keys()) {
            state = this.root.get(key);
            state.setFail(this.root);
            q.add(state);
        }
        while (!q.isEmpty()) {
            state = q.pop();
            for (char key : keys = state.keys()) {
                State s = state.get(key);
                q.add(s);
                State r = state.getFail();
                while (r.get(key) == null) {
                    r = r.getFail();
                }
                s.setFail(r.get(key));
                s.getOutputs().addAll(r.get(key).getOutputs());
            }
        }
    }

    State getRoot() {
        return this.root;
    }

    SearchResult startSearch(char[] chars) {
        if (!this.prepared) {
            throw new IllegalStateException("can't start search until prepare()");
        }
        return this.continueSearch(new SearchResult(this.root, chars, 0));
    }

    SearchResult continueSearch(SearchResult lastResult) {
        SearchResult searchResult = null;
        char[] chars = lastResult.chars;
        State state = lastResult.lastMatchedState;
        Integer currentIndex = lastResult.lastIndex;
        while (this.shouldContinueSearching(searchResult, currentIndex, chars)) {
            char currentChar = chars[currentIndex];
            while (state.get(currentChar) == null) {
                state = state.getFail();
            }
            if (this.shouldCreateSearchResult(state = state.get(currentChar))) {
                searchResult = new SearchResult(state, chars, currentIndex + 1);
                continue;
            }
            Integer n = currentIndex;
            Integer n2 = currentIndex = Integer.valueOf(currentIndex + 1);
        }
        return searchResult;
    }

    private boolean shouldCreateSearchResult(State state) {
        boolean result = false;
        if (state.getOutputs().size() > 0) {
            result = true;
        }
        return result;
    }

    private boolean shouldContinueSearching(SearchResult searchResult, Integer currentIndex, char[] inputText) {
        return searchResult == null && currentIndex != null && currentIndex < inputText.length;
    }

    private TokensInformation extractTokensInformation(char[] chars) {
        TokensInformation result = new TokensInformation();
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> ends = new ArrayList<Integer>();
        Tokenizer tokenizer = this.createTokenizer(chars);
        OffsetAttribute offsetAttribute = (OffsetAttribute)tokenizer.addAttribute(OffsetAttribute.class);
        try {
            while (tokenizer.incrementToken()) {
                starts.add(offsetAttribute.startOffset());
                ends.add(offsetAttribute.endOffset());
            }
            tokenizer.end();
            tokenizer.close();
        }
        catch (Exception e) {
            System.err.println("Error tokenizing the input text: " + e.getMessage());
        }
        result.setEnds(ends);
        result.setStarts(starts);
        return result;
    }

    private Tokenizer createTokenizer(char[] chars) {
        return new StandardTokenizer(Version.LUCENE_36, (Reader)new StringReader(new String(chars)));
    }

    private void sortOutputResults(List<OutputResult> outputResults) {
        Collections.sort(outputResults, new Comparator<OutputResult>(){

            @Override
            public int compare(OutputResult o1, OutputResult o2) {
                return o1.getStartIndex() - o2.getStartIndex();
            }
        });
    }

    private List<OutputResult> recollectOutputResults(Searcher searcher, char[] chars, boolean onlyTokens) {
        TokensInformation tokensInformation = null;
        ArrayList<OutputResult> result = new ArrayList<OutputResult>();
        if (onlyTokens) {
            tokensInformation = this.extractTokensInformation(chars);
        }
        while (searcher.hasNext()) {
            SearchResult searchResult = searcher.next();
            for (Object output : searchResult.getOutputs()) {
                Integer startIndex = searchResult.lastIndex - this.outputSizeCalculator.calculateSize(output);
                if (onlyTokens && !tokensInformation.areValidOffsets(startIndex, searchResult.lastIndex)) continue;
                result.add(new OutputResult(output, startIndex, searchResult.lastIndex));
            }
        }
        return result;
    }
}

