/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

public class OutputResult {
    private Object output;
    private int startIndex;
    private int lastIndex;

    public OutputResult(Object output, int startIndex, int lastIndex) {
        this.output = output;
        this.startIndex = startIndex;
        this.lastIndex = lastIndex;
    }

    public Object getOutput() {
        return this.output;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public boolean isOverlapped(OutputResult other) {
        return this.startIndex <= other.startIndex && other.startIndex < this.lastIndex || this.startIndex < other.lastIndex && other.lastIndex <= this.lastIndex;
    }

    public boolean dominate(OutputResult other) {
        return this.isOverlapped(other) && (this.startIndex < other.startIndex || this.startIndex == other.startIndex && this.lastIndex > other.lastIndex);
    }

    public String toString() {
        return "[" + this.getStartIndex() + "," + this.getLastIndex() + "]: " + this.getOutput();
    }
}

