/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import java.io.Serializable;
import org.arabidopsis.ahocorasick.EdgeList;
import org.arabidopsis.ahocorasick.State;

class SparseEdgeList
implements EdgeList {
    private static final long serialVersionUID = -7137115190091190011L;
    private Cons head = null;

    public State get(char c) {
        Cons cons = this.head;
        while (cons != null) {
            if (cons.c == c) {
                return cons.s;
            }
            cons = cons.next;
        }
        return null;
    }

    public void put(char c, State s) {
        this.head = new Cons(c, s, this.head);
    }

    public char[] keys() {
        int length = 0;
        Cons c = this.head;
        while (c != null) {
            ++length;
            c = c.next;
        }
        char[] result = new char[length];
        c = this.head;
        int j = 0;
        while (c != null) {
            result[j] = c.c;
            ++j;
            c = c.next;
        }
        return result;
    }

    private static class Cons
    implements Serializable {
        private static final long serialVersionUID = 7161279283678706514L;
        char c;
        State s;
        Cons next;

        public Cons(char c, State s, Cons next) {
            this.c = c;
            this.s = s;
            this.next = next;
        }
    }
}

