/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.arabidopsis.ahocorasick.EdgeList;
import org.arabidopsis.ahocorasick.SparseEdgeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class State
implements Serializable {
    private static final long serialVersionUID = -5773620235137320488L;
    private int depth;
    private EdgeList edgeList;
    private State fail;
    private Set<Object> outputs;

    public State(int depth) {
        this.depth = depth;
        this.edgeList = new SparseEdgeList();
        this.fail = null;
        this.outputs = new HashSet<Object>();
    }

    public State extend(char c) {
        if (this.edgeList.get(c) != null) {
            return this.edgeList.get(c);
        }
        State nextState = new State(this.depth + 1);
        this.edgeList.put(c, nextState);
        return nextState;
    }

    public State extendAll(char[] chars) {
        State state = this;
        for (int i = 0; i < chars.length; ++i) {
            state = state.edgeList.get(chars[i]) != null ? state.edgeList.get(chars[i]) : state.extend(chars[i]);
        }
        return state;
    }

    public int size() {
        char[] keys = this.edgeList.keys();
        int result = 1;
        for (int i = 0; i < keys.length; ++i) {
            result += this.edgeList.get(keys[i]).size();
        }
        return result;
    }

    public State get(char c) {
        State s = this.edgeList.get(c);
        if (s == null && this.isRoot().booleanValue()) {
            s = this;
        }
        return s;
    }

    public void put(char c, State s) {
        this.edgeList.put(c, s);
    }

    public char[] keys() {
        return this.edgeList.keys();
    }

    public State getFail() {
        return this.fail;
    }

    public void setFail(State f) {
        this.fail = f;
    }

    public void addOutput(Object o) {
        this.outputs.add(o);
    }

    public Set<Object> getOutputs() {
        return this.outputs;
    }

    public Boolean isRoot() {
        return this.depth == 0;
    }

    public int getDepth() {
        return this.depth;
    }
}

