/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.termcreation;

import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_arg
extends ExecuteOnlyCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term n = args[0];
        Term term = args[1];
        Term arg = args[2];
        if (n instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        if (term instanceof VariableTerm) {
            PrologException.instantiationError();
        }
        if (!(n instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, n);
        }
        IntegerTerm in = (IntegerTerm)n;
        if (in.value < 0) {
            PrologException.domainError(TermConstants.notLessThanZeroAtom, in);
        }
        if (!(term instanceof CompoundTerm)) {
            PrologException.typeError(TermConstants.compoundAtom, term);
        }
        CompoundTerm ct = (CompoundTerm)term;
        if (ct.tag.arity < in.value) {
            return -1;
        }
        if (in.value == 0) {
            return -1;
        }
        int undoPos = interpreter.getUndoPosition();
        int rc = interpreter.unify(ct.args[in.value - 1], arg);
        if (rc == -1) {
            interpreter.undo(undoPos);
            return -1;
        }
        return 1;
    }
}

